/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.DoubleValueStream;

public class DoubleMultiPointField
extends AnalyticsField
implements DoubleValueStream.CastingDoubleValueStream {
    private SortedNumericDocValues docValues;
    private int count = 0;
    private double[] values = new double[20];

    public DoubleMultiPointField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues.advanceExact(doc)) {
            this.count = this.docValues.docValueCount();
            this.resizeEmptyValues(this.count);
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = NumericUtils.sortableLongToDouble((long)this.docValues.nextValue());
            }
        } else {
            this.count = 0;
        }
    }

    private void resizeEmptyValues(int count) {
        if (count > this.values.length) {
            this.values = new double[count];
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamDoubles(value -> cons.accept(Double.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamDoubles(value -> cons.accept(value));
    }
}

