/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.traccar.database.DataManager;
import org.traccar.database.SimpleObjectManager;
import org.traccar.model.User;

public class UsersManager
extends SimpleObjectManager<User> {
    private Map<String, User> usersTokens;

    public UsersManager(DataManager dataManager) {
        super(dataManager, User.class);
        if (this.usersTokens == null) {
            this.usersTokens = new ConcurrentHashMap<String, User>();
        }
    }

    private void putToken(User user) {
        if (this.usersTokens == null) {
            this.usersTokens = new ConcurrentHashMap<String, User>();
        }
        if (user.getToken() != null) {
            this.usersTokens.put(user.getToken(), user);
        }
    }

    @Override
    protected void addNewItem(User user) {
        super.addNewItem(user);
        this.putToken(user);
    }

    @Override
    protected void updateCachedItem(User user) {
        User cachedUser = (User)this.getById(user.getId());
        super.updateCachedItem(user);
        this.putToken(user);
        if (cachedUser.getToken() != null && !cachedUser.getToken().equals(user.getToken())) {
            this.usersTokens.remove(cachedUser.getToken());
        }
    }

    @Override
    protected void removeCachedItem(long userId) {
        User cachedUser = (User)this.getById(userId);
        if (cachedUser != null) {
            String userToken = cachedUser.getToken();
            super.removeCachedItem(userId);
            if (userToken != null) {
                this.usersTokens.remove(userToken);
            }
        }
    }

    @Override
    public Set<Long> getManagedItems(long userId) {
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(this.getUserItems(userId));
        result.add(userId);
        return result;
    }

    public User getUserByToken(String token) {
        return this.usersTokens.get(token);
    }
}

