/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import org.traccar.Context;
import org.traccar.Main;
import org.traccar.database.StatisticsManager;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notificators.Notificator;
import org.traccar.sms.SmsManager;

public final class NotificatorSms
extends Notificator {
    private final SmsManager smsManager;

    public NotificatorSms() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String smsClass = Context.getConfig().getString("notificator.sms.manager.class", "");
        this.smsManager = smsClass.length() > 0 ? (SmsManager)Class.forName(smsClass).newInstance() : Context.getSmsManager();
    }

    @Override
    public void sendAsync(long userId, Event event, Position position) {
        User user = Context.getPermissionsManager().getUser(userId);
        if (user.getPhone() != null) {
            ((StatisticsManager)Main.getInjector().getInstance(StatisticsManager.class)).registerSms();
            this.smsManager.sendMessageAsync(user.getPhone(), NotificationFormatter.formatShortMessage(userId, event, position), false);
        }
    }

    @Override
    public void sendSync(long userId, Event event, Position position) throws MessageException, InterruptedException {
        User user = Context.getPermissionsManager().getUser(userId);
        if (user.getPhone() != null) {
            ((StatisticsManager)Main.getInjector().getInstance(StatisticsManager.class)).registerSms();
            this.smsManager.sendMessageSync(user.getPhone(), NotificationFormatter.formatShortMessage(userId, event, position), false);
        }
    }
}

