/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.NullResourceProvider;

public class NullResource
extends AbstractResource {
    public static final NullResource INSTANCE = NullResource.create();
    private final URI _uri;

    public static NullResource instance() {
        return INSTANCE;
    }

    public NullResource(InternalResourceProvider resourceProvider, String path, String fullPath) {
        super(resourceProvider, path);
        try {
            this._uri = new URI("nullResource:" + fullPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new NullResourceException(this.toURI().toString());
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        throw new NullResourceException(this.toURI().toString());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public URI toURI() {
        return this._uri;
    }

    public static NullResource createFromRoot(String root) {
        return (NullResource)new NullResourceProvider(root).getRootResource();
    }

    public static NullResource create() {
        return NullResource.createFromRoot("/");
    }

    public static class NullResourceException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public NullResourceException(String s) {
            super(s);
        }
    }
}

