/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class StringSplitter {
    private final char _delim;
    private final String _blockIgnore;

    public StringSplitter(char delim) {
        this(delim, null);
    }

    public StringSplitter(char delim, char blockIgnore) {
        this(delim, String.valueOf(blockIgnore));
    }

    public StringSplitter(char delim, String blockIgnore) {
        this._delim = delim;
        if (blockIgnore != null && blockIgnore.length() == 0) {
            throw new IllegalArgumentException("block ignore cannot be the empty string");
        }
        this._blockIgnore = blockIgnore;
    }

    public String[] split(String s) {
        List<String> ss = this.splitAsList(s);
        if (ss == null) {
            return null;
        }
        return ss.toArray(new String[ss.size()]);
    }

    public List<String> splitAsList(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        if (this._blockIgnore == null) {
            return this.splitNoBlockIgnore(s);
        }
        return this.splitBlockIgnore(s);
    }

    public Set<String> splitAsSet(String s) {
        String[] ss = this.split(s);
        if (ss == null) {
            return null;
        }
        TreeSet<String> res = new TreeSet<String>();
        for (int i = 0; i < ss.length; ++i) {
            res.add(ss[i]);
        }
        return res;
    }

    public Iterator<String> splitToIterator(String s) {
        if (s == null) {
            return null;
        }
        if (this._blockIgnore == null) {
            return new SplitNoBlockIgnoreIterator(s);
        }
        throw new RuntimeException("TODO");
    }

    private List<String> splitNoBlockIgnore(String s) {
        int len = s.length();
        ArrayList<String> res = new ArrayList<String>();
        int idx = 0;
        int prev = 0;
        while (true) {
            if ((idx = s.indexOf(this._delim, idx)) == -1) break;
            if (prev == idx) {
                res.add("");
            } else {
                res.add(s.substring(prev, idx));
            }
            prev = ++idx;
        }
        res.add(prev == len ? "" : s.substring(prev));
        return res;
    }

    private List<String> splitBlockIgnore(String s) {
        if (s.indexOf(this._blockIgnore) == -1) {
            return this.splitNoBlockIgnore(s);
        }
        boolean inBlockIgnore = false;
        int blockIgnoreIdx = 0;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> al = new ArrayList<String>();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == this._blockIgnore.charAt(blockIgnoreIdx)) {
                if (this._blockIgnore.length() == ++blockIgnoreIdx) {
                    blockIgnoreIdx = 0;
                    inBlockIgnore = !inBlockIgnore;
                }
                sb.append(c);
                continue;
            }
            blockIgnoreIdx = 0;
            if (c == this._delim) {
                if (inBlockIgnore) {
                    sb.append(c);
                    continue;
                }
                al.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        al.add(sb.toString());
        return al;
    }

    private class SplitNoBlockIgnoreIterator
    implements Iterator<String> {
        private final String _s;
        private int _idx = 0;
        private int _prev = 0;
        private String _next = null;

        private SplitNoBlockIgnoreIterator(String s) {
            this._s = s;
            if (this._s.length() == 0) {
                this._next = null;
                this._idx = -1;
            } else {
                this._next = this.advanceNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public String next() {
            String next = this._next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this._next = this.advanceNext();
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String advanceNext() {
            if (this._idx == -1) {
                return null;
            }
            this._idx = this._s.indexOf(StringSplitter.this._delim, this._idx);
            if (this._idx == -1) {
                return this._prev == this._s.length() ? "" : this._s.substring(this._prev);
            }
            try {
                if (this._prev == this._idx) {
                    String string = "";
                    return string;
                }
                String string = this._s.substring(this._prev, this._idx);
                return string;
            }
            finally {
                this._prev = ++this._idx;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported!");
        }
    }
}

