/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchSystem;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.Repository;

public class KetchLeaderCache {
    private final KetchSystem system;
    private final ConcurrentMap<String, KetchLeader> leaders;
    private final Lock startLock;

    public KetchLeaderCache(KetchSystem system) {
        this.system = system;
        this.leaders = new ConcurrentHashMap<String, KetchLeader>();
        this.startLock = new ReentrantLock(true);
    }

    public KetchLeader get(Repository repo) throws URISyntaxException {
        String key2 = KetchLeaderCache.computeKey(repo);
        KetchLeader leader = (KetchLeader)this.leaders.get(key2);
        if (leader != null) {
            return leader;
        }
        return this.startLeader(key2, repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KetchLeader startLeader(String key2, Repository repo) throws URISyntaxException {
        this.startLock.lock();
        try {
            KetchLeader leader = (KetchLeader)this.leaders.get(key2);
            if (leader != null) {
                KetchLeader ketchLeader = leader;
                return ketchLeader;
            }
            leader = this.system.createLeader(repo);
            this.leaders.put(key2, leader);
            KetchLeader ketchLeader = leader;
            return ketchLeader;
        }
        finally {
            this.startLock.unlock();
        }
    }

    private static String computeKey(Repository repo) {
        if (repo instanceof DfsRepository) {
            DfsRepository dfs = (DfsRepository)repo;
            return dfs.getDescription().getRepositoryName();
        }
        if (repo.getDirectory() != null) {
            return repo.getDirectory().toURI().toString();
        }
        throw new IllegalArgumentException();
    }
}

