/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceLookup;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.sourceRequested()) {
            return;
        }
        boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
        SourceLookup source = context.lookup().source();
        FetchSourceContext fetchSourceContext = context.fetchSourceContext();
        assert (fetchSourceContext.fetchSource());
        if (source.source() == null && source.internalSourceRef() == null) {
            if (FetchSourcePhase.containsFilters(fetchSourceContext)) {
                throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.indexShard().shardId().getIndexName() + "]");
            }
            return;
        }
        if (!nestedHit && !FetchSourcePhase.containsFilters(fetchSourceContext)) {
            hitContext.hit().sourceRef(source.internalSourceRef());
            return;
        }
        Map<String, Object> value = source.filter(fetchSourceContext);
        if (nestedHit) {
            value = this.getNestedSource(value, hitContext);
        }
        try {
            int initialCapacity = nestedHit ? 1024 : Math.min(1024, source.internalSourceRef().length());
            BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
            XContentBuilder builder = new XContentBuilder(source.sourceContentType().xContent(), (OutputStream)streamOutput);
            if (value != null) {
                builder.value(value);
            } else {
                builder.startObject();
                builder.endObject();
            }
            hitContext.hit().sourceRef(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
        }
    }

    private static boolean containsFilters(FetchSourceContext context) {
        return context.includes().length != 0 || context.excludes().length != 0;
    }

    private Map<String, Object> getNestedSource(Map<String, Object> sourceAsMap, FetchSubPhase.HitContext hitContext) {
        for (SearchHit.NestedIdentity o = hitContext.hit().getNestedIdentity(); o != null; o = o.getChild()) {
            if ((sourceAsMap = (Map)sourceAsMap.get(o.getField().string())) != null) continue;
            return null;
        }
        return sourceAsMap;
    }
}

