/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.context.ParserWalkerChange;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;
import org.jdom.Element;

public class ContextCommit
extends ContextChange {
    private TripleSymbol sym;
    private int num;
    private int mask;
    private boolean flow;

    public ContextCommit() {
    }

    @Override
    public void validate() {
    }

    public ContextCommit(TripleSymbol s, int sbit, int ebit, boolean fl) {
        this.sym = s;
        this.flow = fl;
        MutableInt n = new MutableInt();
        MutableInt zero = new MutableInt(0);
        MutableInt m = new MutableInt();
        Utils.calc_maskword(s.getLocation(), sbit, ebit, n, zero, m);
        this.num = n.get();
        this.mask = m.get();
    }

    @Override
    public void apply(ParserWalkerChange pos) {
        pos.getParserContext().addCommit(this.sym, this.num, this.mask, this.flow, pos.getPoint());
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<commit");
        XmlUtils.a_v_u(s, "id", this.sym.getId());
        XmlUtils.a_v_i(s, "num", this.num);
        XmlUtils.a_v_u(s, "mask", Utils.unsignedInt(this.mask));
        XmlUtils.a_v_b(s, "flow", this.flow);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        int id = XmlUtils.decodeUnknownInt(el.getAttributeValue("id"));
        this.sym = (TripleSymbol)trans.findSymbol(id);
        this.num = XmlUtils.decodeUnknownInt(el.getAttributeValue("num"));
        this.mask = XmlUtils.decodeUnknownInt(el.getAttributeValue("mask"));
        String value = el.getAttributeValue("flow");
        this.flow = value != null ? XmlUtils.decodeBoolean(value) : true;
    }
}

