/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.ByteField;
import db.DBBuffer;
import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.ShortField;
import db.StringField;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapterV0;
import ghidra.program.database.mem.MemoryMapDBAdapterV1;
import ghidra.program.database.mem.MemoryMapDBAdapterV2;
import ghidra.program.database.mem.OverlayMemoryBlockDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MappedMemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;

abstract class MemoryMapDBAdapter {
    static final String TABLE_NAME = "Memory Blocks";
    static final int CURRENT_VERSION = 2;
    static Schema BLOCK_SCHEMA = new Schema(2, "Key", new Class[]{StringField.class, StringField.class, StringField.class, ByteField.class, LongField.class, ShortField.class, LongField.class, LongField.class, IntField.class, IntField.class}, new String[]{"Name", "Comments", "Source Name", "Permissions", "Start Address", "Block Type", "Overlay Address", "Length", "Chain Buffer ID", "Segment"});
    static final int NAME_COL = 0;
    static final int COMMENTS_COL = 1;
    static final int SOURCE_COL = 2;
    static final int PERMISSIONS_COL = 3;
    static final int START_ADDR_COL = 4;
    static final int BLOCK_TYPE_COL = 5;
    static final int OVERLAY_ADDR_COL = 6;
    static final int LENGTH_COL = 7;
    static final int CHAIN_BUF_COL = 8;
    static final int SEGMENT_COL = 9;
    static final int INITIALIZED = 0;
    static final int UNINITIALIZED = 1;
    static final int BIT_MAPPED = 2;
    static final int BYTE_MAPPED = 4;

    MemoryMapDBAdapter() {
    }

    static MemoryMapDBAdapter getAdapter(DBHandle handle, int openMode, MemoryMapDB memMap, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new MemoryMapDBAdapterV2(handle, memMap, true);
        }
        try {
            return new MemoryMapDBAdapterV2(handle, memMap, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            MemoryMapDBAdapter adapter = MemoryMapDBAdapter.findReadOnlyAdapter(handle, memMap);
            if (openMode == 3) {
                adapter = MemoryMapDBAdapter.upgrade(handle, adapter, memMap, monitor);
            }
            return adapter;
        }
    }

    static MemoryMapDBAdapter findReadOnlyAdapter(DBHandle handle, MemoryMapDB memMap) throws VersionException, IOException {
        try {
            return new MemoryMapDBAdapterV1(handle, memMap);
        }
        catch (VersionException versionException) {
            return new MemoryMapDBAdapterV0(handle, memMap);
        }
    }

    static MemoryMapDBAdapter upgrade(DBHandle handle, MemoryMapDBAdapter oldAdapter, MemoryMapDB memMap, TaskMonitor monitor) throws VersionException, IOException {
        try {
            monitor.setMessage("Upgrading Memory Blocks...");
            MemoryBlockDB[] blocks = oldAdapter.getMemoryBlocks();
            monitor.initialize((long)(blocks.length * 2));
            MemoryMapDBAdapterV2 newAdapter = new MemoryMapDBAdapterV2(handle, memMap, true);
            for (int i = 0; i < blocks.length; ++i) {
                MemoryBlockDB block = blocks[i];
                MemoryBlockDB newBlock = null;
                if (blocks[i].isInitialized()) {
                    DBBuffer buf = block.getBuffer();
                    newBlock = ((MemoryMapDBAdapter)newAdapter).createInitializedBlock(block.getName(), block.getStart(), buf, 4);
                } else {
                    Address mappedAddress = null;
                    MemoryBlockType type = block.getType();
                    if (type == MemoryBlockType.BIT_MAPPED || type == MemoryBlockType.BYTE_MAPPED) {
                        mappedAddress = ((MappedMemoryBlock)((Object)block)).getOverlayedMinAddress();
                    }
                    newBlock = ((MemoryMapDBAdapter)newAdapter).createBlock(block.getType(), block.getName(), block.getStart(), block.getSize(), mappedAddress, false, 4);
                }
                newBlock.setComment(block.getComment());
                newBlock.setSourceName(block.getSourceName());
                if (block.isExecute()) {
                    newBlock.setExecute(true);
                }
                if (block.isWrite()) {
                    newBlock.setWrite(true);
                }
                if (!block.isVolatile()) continue;
                newBlock.setVolatile(true);
            }
            oldAdapter.deleteTable(handle);
            ((MemoryMapDBAdapter)newAdapter).refreshMemory();
            return newAdapter;
        }
        catch (AddressOverflowException e) {
            throw new AssertException((Throwable)((Object)e));
        }
    }

    static MemoryBlockDB getMemoryBlock(MemoryMapDBAdapter adapter, Record record, DBBuffer buf, MemoryMapDB memMap) throws IOException {
        short blockType = record.getShortValue(5);
        switch (blockType) {
            case 0: 
            case 1: {
                return new MemoryBlockDB(adapter, record, buf, memMap);
            }
            case 2: 
            case 4: {
                return new OverlayMemoryBlockDB(adapter, record, memMap);
            }
        }
        throw new IllegalStateException("Bad block type");
    }

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract void refreshMemory() throws IOException;

    abstract MemoryBlockDB[] getMemoryBlocks();

    abstract MemoryBlockDB createInitializedBlock(String var1, Address var2, InputStream var3, long var4, int var6) throws AddressOverflowException, IOException;

    abstract MemoryBlockDB createInitializedBlock(String var1, Address var2, DBBuffer var3, int var4) throws AddressOverflowException, IOException;

    abstract MemoryBlockDB createBlock(MemoryBlockType var1, String var2, Address var3, long var4, Address var6, boolean var7, int var8) throws AddressOverflowException, IOException;

    abstract MemoryBlockDB splitBlock(MemoryBlockDB var1, long var2) throws IOException;

    abstract MemoryBlockDB joinBlocks(MemoryBlockDB var1, MemoryBlockDB var2) throws IOException;

    abstract void deleteMemoryBlock(MemoryBlockDB var1) throws IOException;

    abstract void updateBlockRecord(Record var1) throws IOException;

    abstract DBBuffer createBuffer(int var1, byte var2) throws IOException;

    abstract DBBuffer getBuffer(int var1) throws IOException;
}

