/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.KeyToRecordIterator;
import db.Record;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

class SymbolDatabaseAdapterV0
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 0;
    private static final int V0_SYMBOL_NAME_COL = 0;
    private static final int V0_SYMBOL_IS_DYNAMIC_COL = 1;
    private static final int V0_SYMBOL_LOCAL_COL = 2;
    private static final int V0_SYMBOL_PRIMARY_COL = 3;
    private static final int V0_SYMBOL_ADDR_COL = 4;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV0(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    long extractLocalSymbols(DBHandle handle, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Extracting Local and Dynamic Symbols...");
        monitor.initialize((long)this.symbolTable.getRecordCount());
        int cnt = 0;
        RecordIterator iter = this.symbolTable.iterator();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            Record rec = iter.next();
            if (rec.getBooleanValue(2)) {
                SymbolManager.saveLocalSymbol(handle, rec.getKey(), rec.getLongValue(4), rec.getString(0), rec.getBooleanValue(3));
            }
            monitor.setProgress((long)(++cnt));
        }
        return this.symbolTable.getKey();
    }

    private Record convertRecord(Record record) {
        if (record == null) {
            return null;
        }
        if (record.getBooleanValue(1) || record.getBooleanValue(2)) {
            throw new AssertException("Unexpected Symbol");
        }
        Record rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        rec.setString(0, record.getString(0));
        rec.setLongValue(1, record.getLongValue(4));
        rec.setIntValue(5, record.getBooleanValue(3) ? 1 : 0);
        rec.setByteValue(3, SymbolType.CODE.getID());
        rec.setLongValue(4, -1L);
        rec.setLongValue(2, 0L);
        rec.setByteValue(7, (byte)SourceType.USER_DEFINED.ordinal());
        return rec;
    }

    @Override
    Record createSymbol(String name, Address address, long namespaceID, SymbolType symbolType, long data1, int data2, String data3, SourceType source) {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    long[] getSymbolIDs(Address addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Record getSymbolRecord(long symbolID) throws IOException {
        return this.convertRecord(this.symbolTable.getRecord(symbolID));
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, forward)));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, startAddr, forward)));
    }

    @Override
    void updateSymbolRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V0ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        if (!forward) {
            throw new UnsupportedOperationException();
        }
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBLongIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, start, end, forward)));
    }

    void deleteExternalEntries(Address start, Address end) {
        throw new UnsupportedOperationException();
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        if (id == 0L) {
            return new V0ConvertedRecordIterator(this.symbolTable.iterator());
        }
        return null;
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField val = new StringField(name);
        return new V0ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)val, (Field)val, true));
    }

    @Override
    Table getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        throw new UnsupportedOperationException();
    }

    private class V0ConvertedRecordIterator
    implements RecordIterator {
        private RecordIterator symIter;
        private Record rec;

        V0ConvertedRecordIterator(RecordIterator symIter) {
            this.symIter = symIter;
        }

        public boolean hasNext() throws IOException {
            if (this.rec == null) {
                while (this.rec == null && this.symIter.hasNext()) {
                    this.rec = this.symIter.next();
                    if (!this.rec.getBooleanValue(2) && !this.rec.getBooleanValue(1)) continue;
                    this.rec = null;
                }
            }
            return this.rec != null;
        }

        public boolean hasPrevious() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Record next() throws IOException {
            if (this.hasNext()) {
                Record r = this.rec;
                this.rec = null;
                return SymbolDatabaseAdapterV0.this.convertRecord(r);
            }
            return null;
        }

        public Record previous() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

