/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.util.NumericUtilities;
import org.apache.commons.lang3.StringUtils;

public class SegmentedAddressSpace
extends GenericAddressSpace {
    private static final int SIZE = 21;

    public SegmentedAddressSpace(String name, int unique) {
        super(name, 21, 1, unique);
        this.maxOffset = 1114095L;
        this.spaceSize = this.maxOffset + 1L;
        this.maxAddress = this.getUncheckedAddress(this.maxOffset);
    }

    @Override
    public Address getAddress(String addrString) throws AddressFormatException {
        return this.getAddress(addrString, true);
    }

    @Override
    public Address getAddress(String addrString, boolean caseSensitive) throws AddressFormatException {
        int colonPos = addrString.indexOf(58);
        if (colonPos >= 0) {
            String addrSpaceStr = addrString.substring(0, colonPos);
            String offStr = addrString.substring(colonPos + 1);
            if (StringUtils.equals((CharSequence)this.getName(), (CharSequence)addrSpaceStr)) {
                colonPos = offStr.indexOf(58);
                if (colonPos >= 0) {
                    String segString = offStr.substring(0, colonPos);
                    offStr = offStr.substring(colonPos + 1);
                    return this.parseSegmented(segString, offStr);
                }
                return this.parseNonSegmented(offStr);
            }
            return this.parseSegmented(addrSpaceStr, offStr);
        }
        return this.parseNonSegmented(addrString);
    }

    @Override
    public Address subtract(Address addr, long displacement) {
        if (displacement < 0L) {
            return this.add(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize) {
            throw new AddressOutOfBoundsException("Address Overflow in subtract: " + addr + " + " + displacement);
        }
        long off = addr.getOffset() - displacement;
        if (off >= 0L) {
            SegmentedAddress saddr = (SegmentedAddress)addr;
            return new SegmentedAddress(this, off).normalize(saddr.getSegment());
        }
        throw new AddressOutOfBoundsException("Address Overflow in subtract: " + addr + " + " + displacement);
    }

    @Override
    public Address add(Address addr, long displacement) {
        if (displacement < 0L) {
            return this.subtract(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize) {
            throw new AddressOutOfBoundsException("Address Overflow in add: " + addr + " + " + displacement);
        }
        long off = addr.getOffset() + displacement;
        if (off >= 0L && off <= this.maxOffset) {
            SegmentedAddress saddr = (SegmentedAddress)addr;
            return new SegmentedAddress(this, off).normalize(saddr.getSegment());
        }
        throw new AddressOutOfBoundsException("Address Overflow in add: " + addr + " + " + displacement);
    }

    private long parseString(String addr) {
        if (addr.startsWith("0x") || addr.startsWith("0X")) {
            return NumericUtilities.parseHexLong((String)addr.substring(2));
        }
        return NumericUtilities.parseHexLong((String)addr);
    }

    private SegmentedAddress parseNonSegmented(String offStr) throws AddressFormatException {
        try {
            long off = (int)this.parseString(offStr);
            if (off < 0L || off > 1048575L) {
                throw new AddressFormatException("Offset is outside the range 0 to 0xfffff");
            }
            return new SegmentedAddress(this, off);
        }
        catch (NumberFormatException e) {
            throw new AddressFormatException("Cannot parse (" + offStr + ") as a number.");
        }
    }

    private SegmentedAddress parseSegmented(String segStr, String offStr) throws AddressFormatException {
        int seg = -1;
        try {
            seg = (int)this.parseString(segStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (seg < 0 || seg > 65535) {
            throw new AddressFormatException("Segment is outside the range 0 to 0xffff");
        }
        try {
            int off = (int)this.parseString(offStr);
            if (off < 0 || off > 65535) {
                throw new AddressFormatException("Offset is outside the range 0 to 0xffff");
            }
            return new SegmentedAddress(this, seg, off);
        }
        catch (AddressOutOfBoundsException e) {
            throw new AddressFormatException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new AddressFormatException("Cannot parse (" + offStr + ") as a number.");
        }
    }

    @Override
    public SegmentedAddress getAddress(long byteOffset) {
        return new SegmentedAddress(this, byteOffset);
    }

    @Override
    public SegmentedAddress getAddressInThisSpaceOnly(long byteOffset) {
        return new SegmentedAddress(this, byteOffset);
    }

    @Override
    protected SegmentedAddress getUncheckedAddress(long byteOffset) {
        return new SegmentedAddress(byteOffset, this);
    }

    public SegmentedAddress getAddress(int segment, int segmentOffset) {
        if (segmentOffset > 65535) {
            throw new AddressOutOfBoundsException("Offset is too large.");
        }
        if ((long)((segment << 4) + segmentOffset) > this.maxOffset) {
            throw new AddressOutOfBoundsException("Segmented address is too large.");
        }
        return new SegmentedAddress(this, segment, segmentOffset);
    }

    @Override
    public SegmentedAddressSpace getPhysicalSpace() {
        return this;
    }

    @Override
    public int getPointerSize() {
        return 2;
    }
}

