/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.QWordDataType;

public class SignedQWordDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final SignedQWordDataType dataType = new SignedQWordDataType();

    public SignedQWordDataType() {
        this(null);
    }

    public SignedQWordDataType(DataTypeManager dtm) {
        super("sqword", true, dtm);
    }

    @Override
    public String getDescription() {
        return "Signed Quad-Word (sdq, 8-bytes)";
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "sdq";
    }

    @Override
    public DataType getOppositeSignednessDataType() {
        return QWordDataType.dataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new SignedQWordDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this, true, dataOrganization, false);
    }
}

