/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.OffsetComparator;
import ghidra.program.model.data.OrdinalComparator;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StructureDataType
extends CompositeDataTypeImpl
implements Structure {
    private static final long serialVersionUID = 1L;
    private static Comparator<Object> ordinalComparator = new OrdinalComparator();
    protected static Comparator<Object> offsetComparator = new OffsetComparator();
    protected int structLength;
    protected int numComponents;
    protected List<DataTypeComponentImpl> components;
    private DataTypeComponentImpl flexibleArrayComponent;

    public StructureDataType(String name, int length) {
        this(CategoryPath.ROOT, name, length);
    }

    public StructureDataType(String name, int length, DataTypeManager dtm) {
        this(CategoryPath.ROOT, name, length, dtm);
    }

    public StructureDataType(CategoryPath path, String name, int length) {
        this(path, name, length, null);
    }

    public StructureDataType(CategoryPath path, String name, int length, DataTypeManager dtm) {
        super(path, name, dtm);
        if (length < 0) {
            throw new IllegalArgumentException("Length can't be negative");
        }
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    public StructureDataType(CategoryPath path, String name, int length, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.components = new ArrayList<DataTypeComponentImpl>();
        this.structLength = length;
        this.numComponents = length;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.structLength == 0 && this.flexibleArrayComponent == null;
    }

    @Override
    public DataTypeComponent getComponentAt(int offset) {
        if (offset >= this.structLength || offset < 0) {
            return null;
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        if (index >= 0) {
            return this.components.get(index);
        }
        if (this.isInternallyAligned()) {
            return null;
        }
        index = -index - 1;
        int ordinal = offset;
        if (index > 0) {
            DataTypeComponent dtc = this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
    }

    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        DataType dt;
        DataTypeComponent dtc = this.getComponentAt(offset);
        if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
            return ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
        }
        return dtc;
    }

    @Override
    public int getLength() {
        if (this.structLength == 0) {
            return 1;
        }
        return this.structLength;
    }

    @Override
    public void delete(int index) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx >= 0) {
            DataTypeComponent dtc = this.components.remove(idx);
            this.shiftOffsets(idx, -1, -dtc.getLength());
            return;
        }
        idx = -idx - 1;
        this.shiftOffsets(idx, -1, -1);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    private void shiftOffsets(int index, int deltaOrdinal, int deltaOffset) {
        for (int i = index; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            this.shiftOffsets(dtc, deltaOrdinal, deltaOffset);
        }
        this.structLength += deltaOffset;
        this.numComponents += deltaOrdinal;
    }

    protected void shiftOffsets(DataTypeComponentImpl dtc, int deltaOrdinal, int deltaOffset) {
        dtc.setOffset(dtc.getOffset() + deltaOffset);
        dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
    }

    @Override
    public DataTypeComponent getComponent(int index) {
        if (index == this.numComponents && this.flexibleArrayComponent != null) {
            return this.flexibleArrayComponent;
        }
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx >= 0) {
            return this.components.get(idx);
        }
        int offset = 0;
        if ((idx = -idx - 1) == 0) {
            offset = index;
        } else {
            DataTypeComponent dtc = this.components.get(idx - 1);
            offset = dtc.getEndOffset() + index - dtc.getOrdinal();
        }
        return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, index, offset);
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public int getNumDefinedComponents() {
        return this.components.size();
    }

    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length, String componentName, String comment) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.validateDataType(dataType);
        if (offset > this.structLength) {
            this.numComponents += offset - this.structLength;
            this.structLength = offset;
        }
        this.checkAncestry(dataType);
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        int additionalShift = 0;
        if (index >= 0) {
            DataTypeComponent dtc = this.components.get(index);
            additionalShift = offset - dtc.getOffset();
        } else {
            index = -index - 1;
        }
        int ordinal = offset;
        if (index > 0) {
            DataTypeComponent dtc = this.components.get(index - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
            return new DataTypeComponentImpl(DataType.DEFAULT, this, 1, ordinal, offset);
        }
        int dtLength = (dataType = dataType.clone(this.getDataTypeManager())).getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(index, 1 + additionalShift, dtc.getLength() + additionalShift);
        this.components.add(index, dtc);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length) {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) {
        if (length < 1) {
            throw new IllegalArgumentException("Length of " + componentName + ": '" + dataType + "' in structure '" + this.name + "' must be >= 1!");
        }
        return this.doAdd(dataType, length, componentName, comment, true, true);
    }

    public void add(DataType dataType, int length, String componentName, String comment, int numCopies) {
        if (length < 1) {
            throw new IllegalArgumentException("Length of " + componentName + ": '" + dataType + "' in structure '" + this.name + "' must be >= 1!");
        }
        for (int ii = 0; ii < numCopies; ++ii) {
            this.doAdd(dataType, length, componentName, comment, false, false);
        }
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    private DataTypeComponent doAdd(DataType dataType, int length, String componentName, String comment, boolean notify, boolean align) {
        DataTypeComponentImpl dtc;
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        boolean isFlexibleArray = false;
        if (dataType == DataType.DEFAULT) {
            dtc = new DataTypeComponentImpl(DataType.DEFAULT, this, 1, this.numComponents, this.structLength);
        } else {
            int offset = this.structLength;
            int ordinal = this.numComponents;
            boolean bl = isFlexibleArray = length == 0;
            if (length == 0) {
                offset = -1;
                ordinal = -1;
                isFlexibleArray = true;
                this.clearFlexibleArrayComponent();
            }
            dataType = dataType.clone(this.getDataTypeManager());
            dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, offset, componentName, comment);
            dataType.addParent(this);
            if (isFlexibleArray) {
                this.flexibleArrayComponent = dtc;
            } else {
                this.components.add(dtc);
            }
        }
        if (!isFlexibleArray) {
            ++this.numComponents;
            this.structLength += dtc.getLength();
        }
        if (align) {
            this.adjustInternalAlignment();
        }
        if (notify) {
            this.notifySizeChanged();
        }
        return dtc;
    }

    @Override
    public void growStructure(int amount) {
        this.numComponents += amount;
        this.structLength += amount;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public DataTypeComponent insert(int index, DataType dataType, int length, String componentName, String comment) {
        if (index < 0 || index > this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index == this.numComponents) {
            return this.add(dataType, length, componentName, comment);
        }
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (dataType == DataType.DEFAULT) {
            this.shiftOffsets(idx, 1, 1);
            return this.getComponent(index);
        }
        int dtLength = (dataType = dataType.clone(this.getDataTypeManager())).getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        int offset = this.getComponent(index).getOffset();
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, index, offset, componentName, comment);
        dataType.addParent(this);
        this.shiftOffsets(idx, 1, dtc.getLength());
        this.components.add(idx, dtc);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
        return dtc;
    }

    @Override
    public void insert(int ordinal, DataType dataType, int length, String name, String comment, int numCopies) {
        if (ordinal < 0 || ordinal > this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        if (ordinal == this.numComponents) {
            this.add(dataType, length, name, comment, numCopies);
            return;
        }
        for (int ii = 0; ii < numCopies; ++ii) {
            this.insert(ordinal + ii, dataType, length, name, comment);
        }
    }

    @Override
    public void deleteAtOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        int index = Collections.binarySearch(this.components, new Integer(offset), offsetComparator);
        int delta = -1;
        if (index < 0) {
            index = -index - 1;
        } else {
            DataTypeComponent dtc = this.components.remove(index);
            dtc.getDataType().removeParent(this);
            delta = -dtc.getLength();
        }
        this.shiftOffsets(index, -1, delta);
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        if (dataType instanceof Structure) {
            int otherNumComps;
            Structure struct = (Structure)dataType;
            if (this.isInternallyAligned() != struct.isInternallyAligned() || this.isDefaultAligned() != struct.isDefaultAligned() || this.isMachineAligned() != struct.isMachineAligned() || this.getMinimumAlignment() != struct.getMinimumAlignment() || this.getPackingValue() != struct.getPackingValue() || !this.isInternallyAligned() && this.getLength() != struct.getLength()) {
                return false;
            }
            DataTypeComponent myFlexComp = this.getFlexibleArrayComponent();
            DataTypeComponent otherFlexComp = struct.getFlexibleArrayComponent();
            if (myFlexComp != null ? otherFlexComp == null || !myFlexComp.isEquivalent(otherFlexComp) : otherFlexComp != null) {
                return false;
            }
            int myNumComps = this.getNumComponents();
            if (myNumComps != (otherNumComps = struct.getNumComponents())) {
                return false;
            }
            for (int i = 0; i < myNumComps; ++i) {
                DataTypeComponent otherDtc;
                DataTypeComponent myDtc = this.getComponent(i);
                if (myDtc.isEquivalent(otherDtc = struct.getComponent(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        int n = this.components.size();
        boolean didChange = false;
        for (int i = 0; i < n; ++i) {
            int consumed;
            int dtcLen;
            DataTypeComponentImpl dtc = this.components.get(i);
            if (dtc.getDataType() != dt) continue;
            int dtLen = dt.getLength();
            if (dtLen < (dtcLen = dtc.getLength())) {
                dtc.setLength(dtLen);
                this.shiftOffsets(i + 1, dtcLen - dtLen, 0);
                didChange = true;
                continue;
            }
            if (dtLen <= dtcLen || (consumed = this.consumeBytesAfter(i, dtLen - dtcLen)) <= 0) continue;
            this.shiftOffsets(i + 1, 0 - consumed, 0);
            didChange = true;
        }
        this.adjustInternalAlignment();
        if (didChange) {
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.adjustInternalAlignment();
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentImpl thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available);
        return available;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.getLength(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        StructureDataType struct = new StructureDataType(this.categoryPath, this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public void clearComponent(int index) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        if (idx >= 0) {
            DataTypeComponent dtc = this.components.remove(idx);
            dtc.getDataType().removeParent(this);
            int len = dtc.getLength();
            if (len > 1) {
                this.shiftOffsets(idx, len - 1, 0);
            }
        }
        this.adjustInternalAlignment();
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Structure)) {
            throw new IllegalArgumentException();
        }
        int oldLength = this.structLength;
        this.doReplaceWith((Structure)dataType);
        if (oldLength != this.structLength) {
            this.notifySizeChanged();
        }
    }

    private void doReplaceWith(Structure struct) {
        DataTypeComponent dtc;
        int i;
        this.components.clear();
        this.flexibleArrayComponent = null;
        if (struct.isNotYetDefined()) {
            this.structLength = 0;
            this.numComponents = 0;
        } else {
            this.numComponents = this.structLength = struct.getLength();
        }
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (i = 0; i < otherComponents.length; ++i) {
            dtc = otherComponents[i];
            DataType dt = dtc.getDataType();
            this.replaceAtOffset(dtc.getOffset(), dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment());
        }
        for (i = 0; i < this.components.size(); ++i) {
            int n;
            dtc = this.components.get(i);
            DataType dataType = dtc.getDataType();
            if (dataType.getLength() <= dtc.getLength() || (n = this.consumeBytesAfter(i, dataType.getLength() - dtc.getLength())) <= 0) continue;
            this.shiftOffsets(i + 1, 0 - n, 0);
        }
        DataTypeComponent flexComponent = struct.getFlexibleArrayComponent();
        if (flexComponent != null) {
            this.setFlexibleArrayComponent(flexComponent.getDataType(), flexComponent.getFieldName(), flexComponent.getComment());
        }
        this.setDataAlignmentInfo(struct);
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        int n = this.components.size();
        for (int i = n - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            if (dtc.getDataType() != dt) continue;
            dt.removeParent(this);
            this.components.remove(i);
            this.shiftOffsets(i, dtc.getLength() - 1, 0);
        }
        this.adjustInternalAlignment();
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        try {
            this.validateDataType(newDt);
            this.checkAncestry(newDt);
        }
        catch (Exception e) {
            newDt = DataType.DEFAULT;
        }
        boolean changed = false;
        int nextIndex = 0;
        Iterator<DataTypeComponentImpl> it = this.components.iterator();
        while (it.hasNext()) {
            ++nextIndex;
            DataTypeComponentImpl comp = it.next();
            DataType compDt = comp.getDataType();
            if (oldDt != compDt) continue;
            oldDt.removeParent(this);
            comp.setDataType(newDt);
            newDt.addParent(this);
            int len = newDt.getLength();
            int oldLen = comp.getLength();
            if (len > 0) {
                if (len < oldLen) {
                    comp.setLength(len);
                    this.shiftOffsets(nextIndex, oldLen - len, 0);
                } else if (len > oldLen) {
                    int bytesNeeded = len - oldLen;
                    int bytesAvailable = this.getNumUndefinedBytes(comp.getOrdinal() + 1);
                    if (bytesNeeded <= bytesAvailable) {
                        comp.setLength(len);
                        this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                    } else if (comp.getOrdinal() == this.getLastDefinedComponentIndex()) {
                        this.doGrowStructure(bytesNeeded - bytesAvailable);
                        comp.setLength(len);
                        this.shiftOffsets(nextIndex, -bytesNeeded, 0);
                    } else {
                        comp.setLength(oldLen + bytesAvailable);
                        this.shiftOffsets(nextIndex, -bytesAvailable, 0);
                    }
                }
            }
            changed = true;
        }
        this.adjustInternalAlignment();
        if (changed) {
            this.notifySizeChanged();
        }
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.getComponent(i);
        }
        return comps;
    }

    @Override
    public DataTypeComponent replace(int index, DataType dataType, int length, String componentName, String comment) {
        if (index < 0 || index >= this.numComponents) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        DataTypeComponentImpl origDtc = (DataTypeComponentImpl)this.getComponent(index);
        DataTypeComponent replacement = this.replace(origDtc, dataType, length, componentName, comment);
        this.adjustInternalAlignment();
        return replacement;
    }

    @Override
    public DataTypeComponent replace(int index, DataType dataType, int length) {
        return this.replace(index, dataType, length, null, null);
    }

    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String componentName, String comment) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (offset >= this.structLength) {
            throw new IllegalArgumentException("Offset " + offset + " is beyond end of structure (" + this.structLength + ").");
        }
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        DataTypeComponentImpl origDtc = (DataTypeComponentImpl)this.getComponentAt(offset);
        DataTypeComponent replacement = this.replace(origDtc, dataType, length, componentName, comment);
        this.adjustInternalAlignment();
        return replacement;
    }

    private DataTypeComponent replace(DataTypeComponentImpl origDtc, DataType dataType, int length, String componentName, String comment) {
        int index;
        int bytesAvailable;
        int ordinal = origDtc.getOrdinal();
        int newOffset = origDtc.getOffset();
        int dtcLength = origDtc.getLength();
        int dtLength = dataType.getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        origDtc.getDataType().removeParent(this);
        DataTypeComponentImpl newDtc = new DataTypeComponentImpl(dataType, this, length, ordinal, newOffset, componentName, comment);
        dataType.addParent(this);
        int bytesNeeded = length - dtcLength;
        int deltaOrdinal = -bytesNeeded;
        if (bytesNeeded > 0 && (bytesAvailable = this.getNumUndefinedBytes(ordinal + 1)) < bytesNeeded) {
            if (ordinal == this.getLastDefinedComponentIndex()) {
                this.growStructure(bytesNeeded - bytesAvailable);
            } else {
                throw new IllegalArgumentException("Not enough undefined bytes to fit " + dataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(newOffset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
            }
        }
        if ((index = Collections.binarySearch(this.components, new Integer(ordinal), ordinalComparator)) < 0) {
            index = -index - 1;
        } else {
            this.components.remove(index);
        }
        this.components.add(index, newDtc);
        if (deltaOrdinal != 0) {
            this.shiftOffsets(index + 1, deltaOrdinal, 0);
        }
        return newDtc;
    }

    private int getLastDefinedComponentIndex() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponent dataTypeComponent = this.components.get(this.components.size() - 1);
        return dataTypeComponent.getOrdinal();
    }

    protected int getNumUndefinedBytes(int index) {
        if (index >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, new Integer(index), ordinalComparator);
        DataTypeComponent dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - index;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - index;
        }
        return 0;
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public void deleteAll() {
        for (int i = 0; i < this.components.size(); ++i) {
            DataTypeComponent dtc = this.components.get(i);
            dtc.getDataType().removeParent(this);
        }
        this.components.clear();
        this.structLength = 0;
        this.numComponents = 0;
        this.flexibleArrayComponent = null;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public void realign() {
        this.adjustInternalAlignment();
    }

    @Override
    public void pack(int packingSize) throws InvalidInputException {
        this.setPackingValue(packingSize);
    }

    protected boolean adjustComponents() {
        boolean internallyAligned = this.isInternallyAligned();
        boolean keepDefinedDefaults = !internallyAligned;
        int oldLength = this.structLength;
        if (!this.isInternallyAligned()) {
            boolean changed = this.adjustUnalignedComponents();
            if (changed && oldLength != this.structLength) {
                this.notifySizeChanged();
            }
            return changed;
        }
        boolean compositeDBChanged = false;
        boolean componentsDBChanged = false;
        int packingAlignment = this.getPackingValue();
        int currentOrdinal = 0;
        int currentOffset = 0;
        int allComponentsLCM = 1;
        for (DataTypeComponentImpl dataTypeComponent : this.components) {
            DataType componentDt = dataTypeComponent.getDataType();
            if (!keepDefinedDefaults && DataType.DEFAULT == componentDt) continue;
            int componentLength = dataTypeComponent.getLength();
            int componentOrdinal = dataTypeComponent.getOrdinal();
            int componentOffset = dataTypeComponent.getOffset();
            int dtLength = componentDt.getLength();
            if (dtLength <= 0) {
                dtLength = componentLength;
            }
            int componentAlignment = this.getPackedAlignment(componentDt, dtLength, packingAlignment);
            allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, componentAlignment);
            int newOffset = DataOrganizationImpl.getOffset(componentAlignment, currentOffset);
            currentOffset = newOffset + dtLength;
            if (componentOrdinal == currentOrdinal && componentOffset == newOffset && componentLength == dtLength) {
                ++currentOrdinal;
                continue;
            }
            dataTypeComponent.setOffset(newOffset);
            dataTypeComponent.setOrdinal(currentOrdinal);
            dataTypeComponent.setLength(dtLength);
            ++currentOrdinal;
            componentsDBChanged = true;
        }
        if (this.flexibleArrayComponent != null) {
            DataType dataType = this.flexibleArrayComponent.getDataType();
            int componentAlignment = this.getPackedAlignment(dataType, dataType.getLength(), packingAlignment);
            currentOffset = DataOrganizationImpl.getOffset(componentAlignment, currentOffset);
            allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, componentAlignment);
        }
        compositeDBChanged = this.updateComposite(currentOrdinal, currentOffset);
        boolean addedPadding = this.alignEndOfStruct(allComponentsLCM);
        if (componentsDBChanged || compositeDBChanged || addedPadding) {
            if (oldLength != this.structLength) {
                this.notifySizeChanged();
            }
            return true;
        }
        return false;
    }

    private int getPackedAlignment(DataType componentDt, int dtLength, int packingAlignment) {
        boolean componentForcingAlignment;
        DataOrganization dataOrganization = this.getDataOrganization();
        int componentAlignment = dataOrganization.getAlignment(componentDt, dtLength);
        int componentForcedAlignment = dataOrganization.getForcedAlignment(componentDt);
        boolean bl = componentForcingAlignment = componentForcedAlignment > 0;
        if (componentForcingAlignment) {
            componentAlignment = DataOrganizationImpl.getLeastCommonMultiple(componentAlignment, componentForcedAlignment);
        }
        if (packingAlignment > 0) {
            if (componentForcedAlignment > packingAlignment) {
                componentAlignment = componentForcedAlignment;
            } else if (componentAlignment > packingAlignment) {
                componentAlignment = packingAlignment;
            }
        }
        return componentAlignment;
    }

    private boolean adjustUnalignedComponents() {
        boolean changed = false;
        int currentOrdinal = 0;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentImpl dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            componentCount += numUndefinedsBefore;
            currentOffset += numUndefinedsBefore;
            ++componentCount;
            currentOffset += componentLength;
            if (dataTypeComponent.getOrdinal() != (currentOrdinal += numUndefinedsBefore)) {
                dataTypeComponent.setOrdinal(currentOrdinal);
                changed = true;
            }
            ++currentOrdinal;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        if (this.updateNumComponents(componentCount += numUndefinedsAfter)) {
            changed = true;
        }
        return changed;
    }

    private boolean updateNumComponents(int currentNumComponents) {
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            return true;
        }
        return false;
    }

    private boolean updateComposite(int currentNumComponents, int currentLength) {
        boolean compositeChanged = false;
        if (this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            compositeChanged = true;
        }
        if (this.structLength != currentLength) {
            this.structLength = currentLength;
            compositeChanged = true;
        }
        return compositeChanged;
    }

    private boolean alignEndOfStruct(int componentLCM) {
        int padSize;
        int minimumAlignment = this.getMinimumAlignment();
        int structureLength = this.getLength();
        if (structureLength == 0) {
            return true;
        }
        int overallAlignment = componentLCM;
        if (minimumAlignment > overallAlignment) {
            overallAlignment = minimumAlignment;
        }
        if ((padSize = DataOrganizationImpl.getPaddingSize(overallAlignment, this.structLength)) > 0) {
            this.doGrowStructure(padSize);
            return true;
        }
        return false;
    }

    private void doGrowStructure(int amount) {
        if (!this.isInternallyAligned()) {
            this.numComponents += amount;
        }
        this.structLength += amount;
    }

    @Override
    public void adjustInternalAlignment() {
        this.adjustComponents();
    }

    @Override
    public boolean hasFlexibleArrayComponent() {
        return this.flexibleArrayComponent != null;
    }

    @Override
    public DataTypeComponent getFlexibleArrayComponent() {
        return this.flexibleArrayComponent;
    }

    @Override
    public DataTypeComponent setFlexibleArrayComponent(DataType flexType, String name, String comment) {
        return this.doAdd(flexType, 0, name, comment, true, true);
    }

    @Override
    public void clearFlexibleArrayComponent() {
        if (this.flexibleArrayComponent == null) {
            return;
        }
        this.flexibleArrayComponent = null;
        this.adjustInternalAlignment();
        this.notifySizeChanged();
    }

    @Override
    protected void dumpComponents(StringBuilder buffer, String pad) {
        super.dumpComponents(buffer, pad);
        DataTypeComponent dtc = this.getFlexibleArrayComponent();
        if (dtc != null) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dataType.getDisplayName() + "[0]");
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }
}

