/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedSymbol;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class LocalSymbolMap {
    private HighFunction func;
    private String spacename;
    private HashMap<MappedVarKey, HighSymbol> addrMappedSymbols;
    private HashMap<Integer, HighSymbol> symbolMap;
    private MappedSymbol[] paramSymbols;
    private static final Comparator<MappedSymbol> PARAM_SYMBOL_SLOT_COMPARATOR = new Comparator<MappedSymbol>(){

        @Override
        public int compare(MappedSymbol sym1, MappedSymbol sym2) {
            return sym1.getSlot() - sym2.getSlot();
        }
    };

    public LocalSymbolMap(HighFunction highFunc, String spcname) {
        this.func = highFunc;
        this.spacename = spcname;
        this.addrMappedSymbols = new HashMap();
        this.symbolMap = new HashMap();
        this.paramSymbols = new MappedSymbol[0];
    }

    public HighFunction getHighFunction() {
        return this.func;
    }

    public void grabFromFunction(boolean includeDefaultNames) {
        Variable[] locals;
        Function dbFunction = this.func.getFunction();
        int uniqueSymbolId = 0;
        for (Variable local : locals = dbFunction.getLocalVariables()) {
            Variable var = local;
            if (!var.isValid()) continue;
            DataType dt = var.getDataType();
            boolean istypelock = true;
            boolean isnamelock = true;
            if (Undefined.isUndefined(dt)) {
                istypelock = false;
            }
            int sz = var.getLength();
            String name = var.getName();
            VariableStorage storage = var.getVariableStorage();
            Address defAddr = null;
            if (!storage.isStackStorage()) {
                defAddr = dbFunction.getEntryPoint().addWrap(var.getFirstUseOffset());
            }
            HighSymbol sym = storage.isHashStorage() ? this.newDynamicSymbol(name, dt, sz, storage.getFirstVarnode().getOffset(), defAddr, 0, ++uniqueSymbolId) : this.newMappedSymbol(name, dt, storage, defAddr, -1, ++uniqueSymbolId);
            sym.setTypeLock(istypelock);
            sym.setNameLock(isnamelock);
        }
        Parameter[] p = dbFunction.getParameters();
        boolean lock = dbFunction.getSignatureSource() != SourceType.DEFAULT;
        Address pcaddr = dbFunction.getEntryPoint();
        try {
            pcaddr = pcaddr.subtract(1L);
        }
        catch (AddressOutOfBoundsException local) {
            // empty catch block
        }
        ArrayList<MappedSymbol> paramList = new ArrayList<MappedSymbol>();
        for (int i = 0; i < p.length; ++i) {
            Parameter var = p[i];
            if (!var.isValid()) continue;
            DataType dt = var.getDataType();
            String name = var.getName();
            VariableStorage storage = var.getVariableStorage();
            Address resAddr = storage.isStackStorage() ? null : pcaddr;
            MappedSymbol paramSymbol = this.newMappedSymbol(name, dt, storage, resAddr, i, ++uniqueSymbolId);
            paramList.add(paramSymbol);
            boolean namelock = true;
            if (!includeDefaultNames) {
                namelock = this.isUserDefinedName(name);
            }
            paramSymbol.setNameLock(namelock);
            paramSymbol.setTypeLock(lock);
        }
        this.paramSymbols = new MappedSymbol[paramList.size()];
        paramList.toArray(this.paramSymbols);
        Arrays.sort(this.paramSymbols, PARAM_SYMBOL_SLOT_COMPARATOR);
        uniqueSymbolId = this.grabEquates(dbFunction, uniqueSymbolId);
    }

    private boolean isUserDefinedName(String name) {
        if (name.startsWith("local_")) {
            return false;
        }
        return !name.startsWith("param_");
    }

    private HighSymbol parseSymbolXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement node = parser.start(new String[]{"mapsym"});
        String typename = node.getAttribute("type");
        HighSymbol res = null;
        if (typename == null) {
            res = new MappedSymbol();
        } else if (typename.equals("dynamic")) {
            res = new DynamicSymbol();
        } else if (typename.equals("equate")) {
            res = new EquateSymbol();
        }
        int symbolId = ((HighSymbol)res).restoreXML(parser, this.func);
        parser.end(node);
        this.insertSymbol(res, symbolId);
        return res;
    }

    public void parseScopeXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"localdb"});
        this.spacename = el.getAttribute("main");
        XmlElement scopeel = parser.start(new String[]{"scope"});
        parser.discardSubTree();
        parser.discardSubTree();
        this.addrMappedSymbols.clear();
        this.symbolMap.clear();
        XmlElement nextEl = parser.peek();
        if (nextEl != null && nextEl.isStart() && "symbollist".equals(nextEl.getName())) {
            this.parseSymbolList(parser);
        }
        parser.end(scopeel);
        parser.end(el);
    }

    public void parseSymbolList(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"symbollist"});
        ArrayList<MappedSymbol> parms = new ArrayList<MappedSymbol>();
        while (parser.peek().isStart()) {
            HighSymbol sym = this.parseSymbolXML(parser);
            if (!(sym instanceof MappedSymbol) || !((MappedSymbol)sym).isParameter()) continue;
            parms.add((MappedSymbol)sym);
        }
        this.paramSymbols = new MappedSymbol[parms.size()];
        parms.toArray(this.paramSymbols);
        Arrays.sort(this.paramSymbols, PARAM_SYMBOL_SLOT_COMPARATOR);
        parser.end(el);
    }

    public String buildLocalDbXML() {
        StringBuilder res = new StringBuilder();
        res.append("<localdb");
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"lock", (boolean)false);
        SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"main", (String)this.spacename);
        res.append(">\n");
        res.append("<scope");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)res, (String)"name", (String)this.func.getFunction().getName());
        res.append(">\n");
        res.append("<parent>\n");
        HighFunction.createNamespaceTag(res, this.func.getFunction().getParentNamespace());
        res.append("</parent>\n");
        res.append("<rangelist/>\n");
        res.append("<symbollist>\n");
        for (HighSymbol sym : this.symbolMap.values()) {
            res.append(sym.buildXML());
        }
        res.append("</symbollist>\n");
        res.append("</scope>\n");
        res.append("</localdb>\n");
        return res.toString();
    }

    public Iterator<HighSymbol> getSymbols() {
        return this.symbolMap.values().iterator();
    }

    public HighSymbol findLocal(VariableStorage store, Address pc) {
        MappedVarKey key = new MappedVarKey(store, pc);
        return this.addrMappedSymbols.get(key);
    }

    public HighSymbol findLocal(Address addr, Address pc) {
        MappedVarKey key = new MappedVarKey(addr, pc);
        return this.addrMappedSymbols.get(key);
    }

    public HighSymbol getSymbol(int id) {
        return this.symbolMap.get(id);
    }

    public int getNumParams() {
        return this.paramSymbols.length;
    }

    public MappedSymbol getParamSymbol(int i) {
        return this.paramSymbols[i];
    }

    public HighParam getParam(int i) {
        return (HighParam)this.paramSymbols[i].getHighVariable();
    }

    public boolean containsVariableWithName(String name) {
        Collection<HighSymbol> values = this.symbolMap.values();
        for (HighSymbol sym : values) {
            if (!sym.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MappedSymbol newMappedSymbol(String nm, DataType dt, VariableStorage store, Address pcaddr, int slot, int id) {
        MappedSymbol sym = new MappedSymbol(nm, dt, store, pcaddr, this.func, slot);
        this.insertSymbol(sym, id);
        return sym;
    }

    public DynamicSymbol newDynamicSymbol(String nm, DataType dt, int sz, long hash, Address pcaddr, int format, int id) {
        DynamicSymbol sym = new DynamicSymbol(nm, dt, sz, this.func, pcaddr, hash, format);
        this.insertSymbol(sym, id);
        return sym;
    }

    private void insertSymbol(HighSymbol sym, int id) {
        if (sym instanceof MappedSymbol) {
            MappedSymbol mapSym = (MappedSymbol)sym;
            MappedVarKey key = new MappedVarKey(mapSym.getStorage(), mapSym.getPCAddress());
            this.addrMappedSymbols.put(key, sym);
        }
        this.symbolMap.put(id, sym);
    }

    private void newEquateSymbol(String nm, long val, long hash, Address addr, int format, TreeMap<String, DynamicSymbol> constantSymbolMap) {
        DynamicSymbol eqSymbol = constantSymbolMap.get(nm);
        if (eqSymbol != null) {
            eqSymbol.addReference(addr, hash, format);
            return;
        }
        int conv = EquateSymbol.convertName(nm, val);
        if (conv < 0) {
            eqSymbol = new EquateSymbol(nm, val, this.func, addr, hash, format);
            eqSymbol.setNameLock(true);
        } else {
            eqSymbol = new EquateSymbol(conv, val, this.func, addr, hash, format);
        }
        constantSymbolMap.put(nm, eqSymbol);
    }

    private int grabEquates(Function dbFunction, int uniqueSymbolId) {
        TreeMap<String, DynamicSymbol> constantSymbolMap = null;
        Program program = dbFunction.getProgram();
        EquateTable equateTable = program.getEquateTable();
        Listing listing = program.getListing();
        AddressIterator equateAddresses = equateTable.getEquateAddresses(dbFunction.getBody());
        while (equateAddresses.hasNext()) {
            Address defAddr = equateAddresses.next();
            for (Equate eq : equateTable.getEquates(defAddr)) {
                long[] hash;
                Instruction instr = listing.getInstructionAt(defAddr);
                if (instr == null) continue;
                for (long element : hash = DynamicHash.calcConstantHash(instr, eq.getValue())) {
                    if (constantSymbolMap == null) {
                        constantSymbolMap = new TreeMap<String, DynamicSymbol>();
                    }
                    this.newEquateSymbol(eq.getDisplayName(), eq.getValue(), element, defAddr, 0, constantSymbolMap);
                }
            }
        }
        if (constantSymbolMap != null) {
            for (DynamicSymbol sym : constantSymbolMap.values()) {
                this.symbolMap.put(++uniqueSymbolId, sym);
            }
        }
        return uniqueSymbolId;
    }

    class MappedVarKey {
        private Address addr;
        private Address pcaddr;

        public MappedVarKey(Address addr, Address pcad) {
            this.addr = addr;
            if (!addr.isStackAddress()) {
                this.pcaddr = pcad;
            }
        }

        public MappedVarKey(VariableStorage store, Address pcad) {
            this.addr = store.getFirstVarnode().getAddress();
            if (!this.addr.isStackAddress()) {
                this.pcaddr = pcad;
            }
        }

        public boolean equals(Object op2) {
            MappedVarKey op = (MappedVarKey)op2;
            if (!SystemUtilities.isEqual((Object)this.pcaddr, (Object)op.pcaddr)) {
                return false;
            }
            return this.addr.equals(op.addr);
        }

        public int hashCode() {
            int hash1 = this.addr.hashCode();
            int hash2 = this.pcaddr != null ? this.pcaddr.hashCode() : 0;
            return hash1 << 4 ^ hash2;
        }
    }
}

