/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class Varnode {
    private static final long[] masks = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private Address address;
    private int size;
    private int spaceID;
    private long offset;

    public Varnode(Address a, int sz) {
        this.address = a;
        AddressSpace space = this.address.getAddressSpace();
        this.spaceID = space.getBaseSpaceID();
        this.size = sz;
        this.offset = this.address.getOffset();
    }

    public Varnode(Address a, int sz, int symbolKey) {
        this(a, sz);
    }

    public int getSize() {
        return this.size;
    }

    public int getSpace() {
        return this.spaceID;
    }

    public Address getAddress() {
        return this.address;
    }

    public Address getPCAddress() {
        if (this.isInput()) {
            return Address.NO_ADDRESS;
        }
        return this.getDef().getSeqnum().getTarget();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getWordOffset() {
        return this.address.getAddressableWordOffset();
    }

    public boolean isFree() {
        return true;
    }

    public boolean contains(Address address) {
        if (this.spaceID != address.getAddressSpace().getUniqueSpaceID()) {
            return false;
        }
        if (this.isConstant() || this.isUnique() || this.isHash()) {
            return this.offset == address.getOffset();
        }
        long endOffset = this.offset;
        if (this.size > 0) {
            endOffset = this.offset + (long)this.size - 1L;
        }
        long addrOffset = address.getOffset();
        if (this.offset > endOffset) {
            return this.offset <= addrOffset;
        }
        return this.offset <= addrOffset && endOffset >= addrOffset;
    }

    public boolean intersects(Varnode varnode) {
        if (this.spaceID != varnode.spaceID) {
            return false;
        }
        if (this.isConstant() || this.isUnique() || this.isHash()) {
            return this.offset == varnode.getOffset();
        }
        long endOtherOffset = varnode.offset;
        if (varnode.size > 0) {
            endOtherOffset = varnode.offset + (long)varnode.size - 1L;
        }
        return this.rangeIntersects(varnode.offset, endOtherOffset);
    }

    private boolean rangeIntersects(long otherOffset, long otherEndOffset) {
        long endOffset = this.offset;
        if (this.size > 0) {
            endOffset = this.offset + (long)this.size - 1L;
        }
        if (this.offset > endOffset) {
            if (otherOffset > otherEndOffset) {
                return true;
            }
            return this.offset <= otherEndOffset;
        }
        if (otherOffset > otherEndOffset) {
            return endOffset >= otherOffset;
        }
        return this.offset <= otherEndOffset && endOffset >= otherOffset;
    }

    public boolean intersects(AddressSetView set) {
        if (this.isConstant() || this.isUnique() || this.isHash() || set == null || set.isEmpty()) {
            return false;
        }
        for (AddressRange range : set.getAddressRanges()) {
            Address minAddr = range.getMinAddress();
            if (minAddr.getAddressSpace().getUniqueSpaceID() != this.spaceID) continue;
            Address maxAddr = range.getMaxAddress();
            if (!this.rangeIntersects(minAddr.getOffset(), maxAddr.getOffset())) continue;
            return true;
        }
        return false;
    }

    public boolean isAddress() {
        int type = 0xF & this.spaceID;
        return type == 1;
    }

    public boolean isRegister() {
        int type = 0xF & this.spaceID;
        return type == 4;
    }

    public boolean isConstant() {
        int type = 0xF & this.spaceID;
        return type == 0;
    }

    public boolean isUnique() {
        int type = 0xF & this.spaceID;
        return type == 3;
    }

    public boolean isHash() {
        return this.spaceID == AddressSpace.HASH_SPACE.getUniqueSpaceID();
    }

    public boolean isInput() {
        return false;
    }

    public boolean isPersistant() {
        return false;
    }

    public boolean isAddrTied() {
        return false;
    }

    public boolean isUnaffected() {
        return false;
    }

    public PcodeOp getDef() {
        return null;
    }

    public Iterator<PcodeOp> getDescendants() {
        return null;
    }

    public PcodeOp getLoneDescend() {
        Iterator<PcodeOp> iter = this.getDescendants();
        if (!iter.hasNext()) {
            return null;
        }
        PcodeOp op = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return op;
    }

    public HighVariable getHigh() {
        return null;
    }

    public short getMergeGroup() {
        return 0;
    }

    public void buildXML(StringBuilder buf) {
        Varnode.buildXMLAddress(buf, this.address, this.size);
    }

    public static void buildXMLAddress(StringBuilder resBuf, Address addr, int size) {
        resBuf.append("<addr");
        Varnode.appendSpaceOffset(resBuf, addr);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
        resBuf.append("/>");
    }

    public static String buildXMLAddress(Address addr) {
        if (addr == null || addr == Address.NO_ADDRESS) {
            return "<addr/>";
        }
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<addr");
        Varnode.appendSpaceOffset(resBuf, addr);
        resBuf.append("/>");
        return resBuf.toString();
    }

    public static String buildXMLAddress(Varnode[] varnodes, int logicalsize) {
        if (varnodes == null) {
            return "<addr/>";
        }
        if (varnodes.length == 1 && logicalsize == 0) {
            StringBuilder buf = new StringBuilder();
            Varnode.buildXMLAddress(buf, varnodes[0].address, varnodes[0].size);
            return buf.toString();
        }
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<addr space=\"join\"");
        int piece = 0;
        for (Varnode vn : varnodes) {
            resBuf.append(" piece");
            resBuf.append(Integer.toString(++piece));
            resBuf.append("=\"");
            Varnode.buildVarnodePiece(resBuf, vn.address, vn.size);
            resBuf.append("\"");
        }
        if (logicalsize != 0) {
            resBuf.append(" logicalsize=\"").append(logicalsize).append('\"');
        }
        resBuf.append("/>");
        return resBuf.toString();
    }

    private static void buildVarnodePiece(StringBuilder buf, Address addr, int size) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace()) {
            space = space.getPhysicalSpace();
            addr = space.getAddress(addr.getOffset());
        }
        buf.append(space.getName());
        buf.append(":0x");
        long off = addr.getUnsignedOffset();
        buf.append(Long.toHexString(off));
        buf.append(':');
        buf.append(Integer.toString(size));
    }

    public static void appendSpaceOffset(StringBuilder buf, Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace()) {
            space = space.getPhysicalSpace();
            addr = space.getAddress(addr.getOffset());
        }
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"space", (String)space.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"offset", (long)addr.getUnsignedOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Varnode readXML(XmlPullParser parser, PcodeFactory factory) throws PcodeXMLException {
        XmlElement el = parser.start(new String[0]);
        try {
            Varnode vn;
            if (el.getName().equals("void")) {
                Varnode varnode = null;
                return varnode;
            }
            String attrstring = el.getAttribute("ref");
            int ref = -1;
            if (attrstring != null && (vn = factory.getRef(ref = SpecXmlUtils.decodeInt((String)attrstring))) != null) {
                Varnode varnode = vn;
                return varnode;
            }
            Address addr = Varnode.readXMLAddress(el, factory.getAddressFactory());
            if (addr == null) {
                Varnode varnode = null;
                return varnode;
            }
            attrstring = el.getAttribute("size");
            int sz = attrstring != null ? SpecXmlUtils.decodeInt((String)attrstring) : 4;
            vn = ref != -1 ? factory.newVarnode(sz, addr, ref) : factory.newVarnode(sz, addr);
            AddressSpace spc = addr.getAddressSpace();
            if (spc != null && spc.getType() == 11) {
                try {
                    factory.readXMLVarnodePieces(el, addr);
                }
                catch (InvalidInputException e) {
                    throw new PcodeXMLException("Invalid varnode pieces: " + e.getMessage());
                }
            }
            if ((attrstring = el.getAttribute("grp")) != null) {
                short val = (short)SpecXmlUtils.decodeInt((String)attrstring);
                factory.setMergeGroup(vn, val);
            }
            if ((attrstring = el.getAttribute("persists")) != null && SpecXmlUtils.decodeBoolean((String)attrstring)) {
                factory.setPersistant(vn, true);
            }
            if ((attrstring = el.getAttribute("addrtied")) != null && SpecXmlUtils.decodeBoolean((String)attrstring)) {
                factory.setAddrTied(vn, true);
            }
            if ((attrstring = el.getAttribute("unaff")) != null && SpecXmlUtils.decodeBoolean((String)attrstring)) {
                factory.setUnaffected(vn, true);
            }
            if ((attrstring = el.getAttribute("input")) != null && SpecXmlUtils.decodeBoolean((String)attrstring)) {
                vn = factory.setInput(vn, true);
            }
            Varnode varnode = vn;
            return varnode;
        }
        finally {
            parser.end(el);
        }
    }

    public void trim() {
        if (this.address.getAddressSpace().getType() == 0) {
            this.offset &= masks[this.size];
            this.address = this.address.getNewAddress(this.offset);
        }
    }

    public String toString() {
        return "(" + this.address.getAddressSpace().getName() + ", 0x" + Long.toHexString(this.offset) + ", " + this.size + ")";
    }

    public String toString(Language language) {
        Register reg;
        if ((this.isAddress() || this.isRegister()) && (reg = language.getRegister(this.address, this.size)) != null) {
            return reg.getName();
        }
        if (this.isUnique()) {
            return "u_" + Long.toHexString(this.offset) + ":" + this.size;
        }
        if (this.isConstant()) {
            return "0x" + Long.toHexString(this.offset);
        }
        return "A_" + this.address + ":" + this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Varnode)) {
            return false;
        }
        Varnode vn = (Varnode)o;
        if (!vn.isFree()) {
            return false;
        }
        return this.offset == vn.getOffset() && this.size == vn.getSize() && this.spaceID == vn.getSpace();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.size;
        result = 31 * result + this.spaceID;
        return result;
    }

    public static Address readXMLAddress(XmlElement el, AddressFactory addrFactory) {
        String localName = el.getName();
        if (localName.equals("spaceid")) {
            AddressSpace spc = addrFactory.getAddressSpace(el.getAttribute("name"));
            int spaceid = spc.getBaseSpaceID();
            spc = addrFactory.getConstantSpace();
            return spc.getAddress(spaceid);
        }
        if (localName.equals("iop")) {
            int ref = SpecXmlUtils.decodeInt((String)el.getAttribute("value"));
            AddressSpace spc = addrFactory.getConstantSpace();
            return spc.getAddress(ref);
        }
        String space = el.getAttribute("space");
        if (space == null) {
            return Address.NO_ADDRESS;
        }
        long offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
        AddressSpace spc = addrFactory.getAddressSpace(space);
        if (spc == null) {
            return null;
        }
        return spc.getAddress(offset);
    }

    public static Address readXMLAddress(String localName, Attributes attr, AddressFactory addrFactory) {
        if (localName.equals("spaceid")) {
            AddressSpace spc = addrFactory.getAddressSpace(attr.getValue("name"));
            int spaceid = spc.getBaseSpaceID();
            spc = addrFactory.getConstantSpace();
            return spc.getAddress(spaceid);
        }
        if (localName.equals("iop")) {
            int ref = SpecXmlUtils.decodeInt((String)attr.getValue("value"));
            AddressSpace spc = addrFactory.getConstantSpace();
            return spc.getAddress(ref);
        }
        String space = attr.getValue("space");
        if (space == null) {
            return Address.NO_ADDRESS;
        }
        long offset = SpecXmlUtils.decodeLong((String)attr.getValue("offset"));
        AddressSpace spc = addrFactory.getAddressSpace(space);
        if (spc == null) {
            return Address.NO_ADDRESS;
        }
        return spc.getAddress(offset);
    }

    public static Address readXMLAddress(String addrstring, AddressFactory addrfactory, AddressSpace refSpace) throws PcodeXMLException {
        int tagstart = addrstring.indexOf(60);
        if (tagstart >= 0) {
            int spaceend;
            int nameend;
            int attrstart;
            if (addrstring.startsWith("spaceid", ++tagstart) && (attrstart = addrstring.indexOf("name=\"", tagstart += 8)) >= 0 && (nameend = addrstring.indexOf(34, attrstart += 6)) >= 0) {
                AddressSpace spc = addrfactory.getAddressSpace(addrstring.substring(attrstart, nameend));
                int spaceid = spc.getBaseSpaceID();
                spc = addrfactory.getConstantSpace();
                return spc.getAddress(spaceid);
            }
            int spacestart = addrstring.indexOf("space=\"");
            if (spacestart >= 4 && (spaceend = addrstring.indexOf(34, spacestart += 7)) >= spacestart) {
                int offend;
                String spcname = addrstring.substring(spacestart, spaceend);
                int offstart = addrstring.indexOf("offset=\"");
                if (offstart >= 4 && (offend = addrstring.indexOf(34, offstart += 8)) >= offstart) {
                    String offstr = addrstring.substring(offstart, offend);
                    AddressSpace spc = addrfactory.getAddressSpace(spcname);
                    if (spc == null) {
                        return Address.NO_ADDRESS;
                    }
                    long offset = SpecXmlUtils.decodeLong((String)offstr);
                    Address addr = spc.getAddress(offset);
                    if (refSpace != null && refSpace.isOverlaySpace()) {
                        return refSpace.getOverlayAddress(addr);
                    }
                    return addr;
                }
            }
        }
        throw new PcodeXMLException("Badly formed address: " + addrstring);
    }
}

