/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.algorithms.LCS;
import ghidra.program.util.CodeUnitContainer;
import java.util.List;

public class CodeUnitLCS
extends LCS<CodeUnitContainer> {
    private List<CodeUnitContainer> xList;
    private List<CodeUnitContainer> yList;

    public CodeUnitLCS(List<CodeUnitContainer> xList, List<CodeUnitContainer> yList) {
        this.xList = xList;
        this.yList = yList;
    }

    protected int lengthOfX() {
        return this.xList.size();
    }

    protected int lengthOfY() {
        return this.yList.size();
    }

    public boolean matches(CodeUnitContainer x, CodeUnitContainer y) {
        return x.getArity() == y.getArity() && x.getMnemonic().equals(y.getMnemonic());
    }

    protected CodeUnitContainer valueOfX(int index) {
        return this.xList.get(index - 1);
    }

    protected CodeUnitContainer valueOfY(int index) {
        return this.yList.get(index - 1);
    }
}

