/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.udif;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.catacombae.dmgextractor.Debug;
import org.catacombae.udif.UDIFBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlistPartition {
    private String name;
    private String id;
    private String attributes;
    private UDIFBlock[] blockList;
    private long partitionSize;
    private final long previousOutOffset;
    private final long previousInOffset;
    private long finalOutOffset = -1L;
    private long finalInOffset = -1L;

    public PlistPartition(String name, String id, String attributes, byte[] data, long previousOutOffset, long previousInOffset) throws IOException {
        this(name, id, attributes, new ByteArrayInputStream(data), previousOutOffset, previousInOffset);
    }

    public PlistPartition(String name, String id, String attributes, InputStream data, long previousOutOffset, long previousInOffset) throws IOException {
        this.name = name;
        this.id = id;
        this.attributes = attributes;
        this.previousOutOffset = previousOutOffset;
        this.previousInOffset = previousInOffset;
        this.blockList = this.parseBlocks(data);
        this.partitionSize = PlistPartition.calculatePartitionSize(this.blockList);
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public long getPartitionSize() {
        return this.partitionSize;
    }

    public UDIFBlock[] getBlocks() {
        UDIFBlock[] res = new UDIFBlock[this.blockList.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.blockList[i];
        }
        return res;
    }

    public Iterator<UDIFBlock> getBlockIterator() {
        return new BlockIterator(this.blockList);
    }

    public int getBlockCount() {
        return this.blockList.length;
    }

    public long getFinalOutOffset() {
        if (this.finalOutOffset < 0L) {
            throw new RuntimeException("parseBlocks has not yet been called!");
        }
        return this.finalOutOffset;
    }

    public long getFinalInOffset() {
        if (this.finalInOffset < 0L) {
            throw new RuntimeException("parseBlocks has not yet been called!");
        }
        return this.finalInOffset;
    }

    private UDIFBlock[] parseBlocks(InputStream is) throws IOException {
        int bytesRead;
        long bytesSkipped = is.read(new byte[204]);
        if (bytesSkipped != 204L) {
            throw new RuntimeException("Could not skip the desired amount of bytes...");
        }
        int blockNumber = 0;
        long lastByteReadInBlock = -1L;
        boolean addInOffset = false;
        byte[] blockData = new byte[UDIFBlock.structSize()];
        LinkedList<UDIFBlock> blocks = new LinkedList<UDIFBlock>();
        while ((bytesRead = is.read(blockData)) != -1) {
            if (bytesRead != blockData.length) {
                throw new RuntimeException("Could not read the desired amount of bytes... (desired: " + blockData.length + " read: " + bytesRead + ")");
            }
            long inOffset = UDIFBlock.peekInOffset(blockData, 0);
            long inSize = UDIFBlock.peekInSize(blockData, 0);
            long outOffsetCompensation = this.previousOutOffset;
            if (lastByteReadInBlock == -1L) {
                lastByteReadInBlock = inOffset;
            }
            lastByteReadInBlock += inSize;
            if (inOffset == 0L && blockNumber == 0) {
                Debug.notification("Detected inOffset == 0, setting addInOffset flag.");
                addInOffset = true;
            }
            long inOffsetCompensation = 0L;
            if (addInOffset) {
                Debug.notification("addInOffset mode: inOffset tranformation " + inOffset + "->" + (inOffset + this.previousInOffset));
                inOffsetCompensation = this.previousInOffset;
            }
            UDIFBlock currentBlock = new UDIFBlock(blockData, 0, outOffsetCompensation, inOffsetCompensation);
            blocks.add(currentBlock);
            ++blockNumber;
            if (currentBlock.getBlockType() != -1) continue;
            this.finalOutOffset = currentBlock.getTrueOutOffset();
            this.finalInOffset = this.previousInOffset + lastByteReadInBlock;
            if (is.read() != -1) {
                Debug.warning("Encountered additional data in blkx blob.");
            }
            return blocks.toArray(new UDIFBlock[blocks.size()]);
        }
        throw new RuntimeException("No BT_END block found!");
    }

    public static long calculatePartitionSize(UDIFBlock[] data) throws IOException {
        long partitionSize = 0L;
        for (UDIFBlock db : data) {
            partitionSize += db.getOutSize();
        }
        return partitionSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockIterator
    implements Iterator<UDIFBlock> {
        private UDIFBlock[] blocks;
        private int pointer;
        private int endOffset;

        public BlockIterator(UDIFBlock[] blocks) {
            this(blocks, 0, blocks.length);
        }

        public BlockIterator(UDIFBlock[] blocks, int offset, int length) {
            this.blocks = blocks;
            this.pointer = offset;
            this.endOffset = offset + length;
        }

        @Override
        public boolean hasNext() {
            return this.pointer < this.endOffset;
        }

        @Override
        public UDIFBlock next() {
            return this.blocks[this.pointer++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

