/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.DockingTool;
import docking.DockingWindowManager;
import docking.WindowPosition;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.help.HelpDescriptor;
import docking.help.HelpService;
import ghidra.util.HelpLocation;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ComponentProvider
implements HelpDescriptor,
ActionContextProvider {
    public static final String DEFAULT_WINDOW_GROUP = "Default";
    private static Map<String, String> oldOwnerMap = new HashMap<String, String>();
    private static Map<String, String> oldNameMap = new HashMap<String, String>();
    protected DockingTool dockingTool;
    private String name;
    private final String owner;
    private String title;
    private String subTitle;
    private String tabText;
    private Icon icon;
    private Set<DockingActionIf> actionSet = new LinkedHashSet<DockingActionIf>();
    private String windowMenuGroup;
    private boolean isTransient;
    private HelpLocation helpLocation;
    private String group = "Default";
    private WindowPosition defaultWindowPosition = WindowPosition.WINDOW;
    private WindowPosition defaultIntraGroupPosition = WindowPosition.STACK;
    private final Class<?> contextType;
    private long instanceID = UniversalIdGenerator.nextID().getValue();
    private boolean instanceIDHasBeenInitialized;

    public ComponentProvider(DockingTool tool, String name, String owner) {
        this(tool, name, owner, null);
    }

    public ComponentProvider(DockingTool tool, String name, String owner, Class<?> contextType) {
        this.dockingTool = tool;
        this.name = name;
        this.owner = owner;
        this.title = name;
        this.contextType = contextType;
    }

    public abstract JComponent getComponent();

    protected void initializeInstanceID(long newID) {
        if (this.instanceIDHasBeenInitialized && newID != this.instanceID) {
            throw new AssertException("Cannot initialize the instanceID more than once");
        }
        this.instanceIDHasBeenInitialized = true;
        this.instanceID = newID;
    }

    public final long getInstanceID() {
        return this.instanceID;
    }

    public void requestFocus() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.getComponent())) {
            return;
        }
        this.getComponent().requestFocus();
    }

    public boolean isFocusedProvider() {
        DockingWindowManager dwm = DockingWindowManager.getInstance(this.getComponent());
        if (dwm == null) {
            return false;
        }
        ComponentPlaceholder placeholder = dwm.getFocusedComponent();
        return placeholder != null && placeholder.getProvider() == this;
    }

    public void addToTool() {
        if (this.isInTool()) {
            throw new IllegalStateException("Component already added: " + this.name);
        }
        this.dockingTool.addComponentProvider(this, false);
        for (DockingActionIf action : this.actionSet) {
            this.dockingTool.addLocalAction(this, action);
        }
        if (this.subTitle != null) {
            this.setSubTitle(this.subTitle);
        }
    }

    public void removeFromTool() {
        this.dockingTool.removeComponentProvider(this);
    }

    protected void addLocalAction(DockingActionIf action) {
        if (this.actionSet.contains(action)) {
            return;
        }
        this.actionSet.add(action);
        if (this.isInTool()) {
            this.dockingTool.addLocalAction(this, action);
        }
    }

    protected void removeLocalAction(DockingAction action) {
        this.actionSet.remove(action);
        if (this.isInTool()) {
            this.dockingTool.removeLocalAction(this, action);
        }
    }

    public void setVisible(boolean visible) {
        if (visible && !this.isInTool()) {
            this.addToTool();
        }
        this.dockingTool.showComponentProvider(this, visible);
    }

    public void toFront() {
        this.dockingTool.toFront(this);
    }

    public boolean isInTool() {
        if (this.dockingTool == null) {
            return false;
        }
        DockingWindowManager manager = this.dockingTool.getWindowManager();
        if (manager == null) {
            return false;
        }
        return manager.containsProvider(this);
    }

    public Class<?> getContextType() {
        return this.contextType;
    }

    public boolean isVisible() {
        return this.dockingTool.isVisible(this);
    }

    public boolean isActive() {
        return this.dockingTool.isActive(this);
    }

    public void closeComponent() {
        if (this.isTransient) {
            this.removeFromTool();
        } else {
            this.setVisible(false);
        }
    }

    public void componentActivated() {
    }

    public void componentDeactived() {
    }

    public void componentHidden() {
    }

    public void componentShown() {
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext(this, this.getComponent());
    }

    public void contextChanged() {
        this.dockingTool.contextChanged(this);
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        this.helpLocation = helpLocation;
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp(this, helpLocation);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.isInTool()) {
            this.dockingTool.updateTitle(this);
        }
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        if (this.isInTool()) {
            this.dockingTool.updateTitle(this);
        }
    }

    public void setTabText(String tabText) {
        this.tabText = tabText;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getTabText() {
        return this.tabText;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.isInTool()) {
            this.dockingTool.getWindowManager().setIcon(this, icon);
        }
    }

    public String getWindowSubMenuName() {
        return this.windowMenuGroup;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    protected void setTransient() {
        this.isTransient = true;
    }

    protected void setWindowMenuGroup(String group) {
        this.windowMenuGroup = group;
    }

    public WindowPosition getDefaultWindowPosition() {
        return this.defaultWindowPosition;
    }

    protected void setDefaultWindowPosition(WindowPosition windowPosition) {
        this.defaultWindowPosition = windowPosition;
    }

    public WindowPosition getIntraGroupPosition() {
        return this.defaultIntraGroupPosition;
    }

    public void setIntraGroupPosition(WindowPosition position) {
        this.defaultIntraGroupPosition = position;
    }

    public String getWindowGroup() {
        return this.group;
    }

    protected void setWindowGroup(String group) {
        this.group = group;
    }

    @Override
    public String getHelpInfo() {
        return "   PROVIDER: " + this.getName() + "\n";
    }

    @Override
    public Object getHelpObject() {
        return this;
    }

    public DockingTool getTool() {
        return this.dockingTool;
    }

    public String toString() {
        return this.name + " - " + this.getTitle() + " - " + this.getSubTitle();
    }

    public static String getMappedOwner(String oldOwner, String oldName) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        return oldOwnerMap.get(key);
    }

    public static String getMappedName(String oldOwner, String oldName) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        return oldNameMap.get(key);
    }

    public static void registerProviderNameOwnerChange(String oldName, String oldOwner, String newName, String newOwner) {
        String key = ComponentProvider.getKey(oldOwner, oldName);
        oldOwnerMap.put(key, newOwner);
        oldNameMap.put(key, newName);
    }

    private static String getKey(String oldOwner, String oldName) {
        return "owner=" + oldOwner + "name=" + oldName;
    }
}

