/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.menu.MenuHandler;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class PopupMenuHandler
extends MenuHandler {
    private final ActionContext actionContext;
    private final DockingWindowManager windowManager;

    public PopupMenuHandler(DockingWindowManager windowManager, ActionContext context) {
        this.windowManager = windowManager;
        this.actionContext = context;
    }

    @Override
    public void menuItemEntered(DockingActionIf action) {
        DockingWindowManager.setMouseOverAction(action);
    }

    @Override
    public void menuItemExited(DockingActionIf action) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void processMenuAction(final DockingActionIf action, ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        this.actionContext.setSource(event.getSource());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupMenuHandler.this.windowManager.setStatusText("");
                if (action.isEnabledForContext(PopupMenuHandler.this.actionContext)) {
                    if (action instanceof ToggleDockingActionIf) {
                        ToggleDockingActionIf toggleAction;
                        toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                    }
                    action.actionPerformed(PopupMenuHandler.this.actionContext);
                }
            }
        });
    }
}

