/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.options.editor.GhidraColorChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorEditor
extends PropertyEditorSupport {
    private static final String LIGHT_COLOR = "SILVER";
    private static final String DARK_COLOR = "BLACK";
    private static GhidraColorChooser colorChooser;
    private JLabel previewLabel = new JLabel();
    private Color color;
    private Color lastUserSelectedColor;

    public ColorEditor() {
        this.previewLabel.setOpaque(true);
        this.previewLabel.setPreferredSize(new Dimension(100, 20));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ColorEditor.this.showDialog(evt.getComponent());
                ColorEditor.this.firePropertyChange();
                ColorEditor.this.updateColor(ColorEditor.this.color);
            }
        });
    }

    private void showDialog(Component parentComponent) {
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        dialogPanel.add((Component)new ColorEditorPanel(), "Center");
        EditorProvider provider = new EditorProvider(dialogPanel);
        DockingWindowManager.showDialog(this.previewLabel, provider);
    }

    @Override
    public Component getCustomEditor() {
        return this.previewLabel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        this.lastUserSelectedColor = this.color = (Color)value;
        this.updateColor(this.color);
    }

    private void updateColor(Color newColor) {
        String colorString = LIGHT_COLOR;
        int colorValue = newColor.getRed() + newColor.getGreen() + newColor.getBlue();
        if (colorValue > 400) {
            colorString = DARK_COLOR;
        }
        this.previewLabel.setText("<HTML><CENTER><I><FONT SIZE=2 COLOR=" + colorString + ">click</FONT></I></CENTER>");
        this.previewLabel.setBackground(this.color);
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.color != null) {
            gfx.setColor(this.color);
        } else {
            gfx.setColor(Color.black);
        }
        gfx.fillRect(box.x, box.y, box.width, box.height);
    }

    class ColorEditorPanel
    extends JPanel {
        ColorEditorPanel() {
            this.setLayout(new BorderLayout());
            if (colorChooser == null) {
                colorChooser = new GhidraColorChooser();
            }
            this.add((Component)colorChooser, "Center");
            colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ColorEditor.this.lastUserSelectedColor = colorChooser.getColor();
                    ColorEditor.this.lastUserSelectedColor = new Color(ColorEditor.this.lastUserSelectedColor.getRed(), ColorEditor.this.lastUserSelectedColor.getGreen(), ColorEditor.this.lastUserSelectedColor.getBlue(), ColorEditor.this.lastUserSelectedColor.getAlpha());
                }
            });
            colorChooser.setColor(ColorEditor.this.color);
        }
    }

    class EditorProvider
    extends DialogComponentProvider {
        EditorProvider(JPanel contentPanel) {
            super("Color Editor", true);
            this.addWorkPanel(contentPanel);
            this.addOKButton();
            this.addCancelButton();
        }

        @Override
        protected void okCallback() {
            ColorEditor.this.color = ColorEditor.this.lastUserSelectedColor;
            this.close();
        }
    }
}

