/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends DialogComponentProvider {
    private JPanel workPanel;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JComboBox<String> choiceCB;
    private JCheckBox anonymousAccess;
    boolean okPressed = false;

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, String namePrompt, String defaultUserID, String choicePrompt, String[] choices, int defaultChoice, boolean includeAnonymousOption) {
        this(title, serverType, serverName, passPrompt, namePrompt, defaultUserID);
        if (choicePrompt != null) {
            this.workPanel.add(new JLabel(choicePrompt));
            this.choiceCB = new JComboBox<String>(choices);
            this.choiceCB.setName("CHOICES-COMPONENT");
            this.choiceCB.setSelectedIndex(defaultChoice);
            this.workPanel.add(this.choiceCB);
        }
        if (includeAnonymousOption) {
            this.anonymousAccess = new JCheckBox("Request Anonymous Access");
            this.anonymousAccess.setName("ANONYMOUS-COMPONENT");
            this.anonymousAccess.addChangeListener(e -> {
                boolean enableOtherFields;
                boolean anonymousAccessRequested = this.anonymousAccess.isSelected();
                boolean bl = enableOtherFields = !anonymousAccessRequested;
                if (anonymousAccessRequested) {
                    this.passwordField.setText("");
                }
                this.passwordField.setEnabled(enableOtherFields);
                if (this.nameField != null) {
                    this.nameField.setEnabled(enableOtherFields);
                }
                if (this.choiceCB != null) {
                    this.choiceCB.setEnabled(enableOtherFields);
                }
            });
            this.workPanel.add(new JLabel(""));
            this.workPanel.add(this.anonymousAccess);
        }
    }

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, String namePrompt, String defaultUserID) {
        this(title, serverType, serverName, passPrompt, namePrompt, defaultUserID, true);
    }

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, String namePrompt, String defaultUserID, boolean hasMessages) {
        super(title, true);
        this.setRememberSize(false);
        if (hasMessages) {
            this.setMinimumSize(300, 150);
        }
        this.workPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.workPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        if (serverName != null) {
            this.workPanel.add(new JLabel(serverType + ":"));
            this.workPanel.add(new JLabel(serverName));
        }
        if (namePrompt != null) {
            this.workPanel.add(new JLabel(namePrompt));
            this.nameField = new JTextField(defaultUserID, 16);
            this.nameField.setName("NAME-ENTRY-COMPONENT");
            this.workPanel.add(this.nameField);
        } else if (defaultUserID != null) {
            this.workPanel.add(new JLabel("User ID:"));
            JLabel nameLabel = new JLabel(defaultUserID);
            nameLabel.setName("NAME-COMPONENT");
            this.workPanel.add(nameLabel);
        }
        this.workPanel.add(new JLabel(passPrompt != null ? passPrompt : "Password:"));
        this.passwordField = new JPasswordField(16);
        this.passwordField.setName("PASSWORD-ENTRY-COMPONENT");
        this.workPanel.add(this.passwordField);
        this.passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            private void displayWarning() {
                try {
                    boolean capsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
                    if (capsLockOn) {
                        PasswordDialog.this.setStatusText("Warning! Caps-Lock is on", MessageType.WARNING);
                    } else {
                        PasswordDialog.this.clearStatusText();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    this.displayWarning();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    this.displayWarning();
                }
            }
        });
        this.addWorkPanel(this.workPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setStatusJustification(0);
        this.setFocusComponent(this.passwordField);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getModifiers() == 0 && e.getKeyChar() == '\n') {
                    PasswordDialog.this.okCallback();
                }
            }
        });
    }

    public void setErrorText(String text) {
        super.setStatusText(text, MessageType.ERROR);
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public boolean anonymousAccessRequested() {
        if (this.anonymousAccess != null) {
            return this.anonymousAccess.isSelected();
        }
        return false;
    }

    public String getUserID() {
        return this.nameField != null ? this.nameField.getText().trim() : null;
    }

    public int getChoice() {
        if (this.choiceCB != null) {
            return this.choiceCB.getSelectedIndex();
        }
        return -1;
    }

    public boolean okWasPressed() {
        return this.okPressed;
    }

    @Override
    protected void okCallback() {
        this.okPressed = true;
        this.close();
    }

    public void dispose() {
        if (this.passwordField != null) {
            this.passwordField.setText("");
            this.rootPanel.remove(this.passwordField);
            this.passwordField = null;
        }
    }
}

