/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.SortListener;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableSortingContext;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;

public abstract class AbstractSortedTableModel<T>
extends AbstractGTableModel<T>
implements SortedTableModel {
    private static final long serialVersionUID = 1L;
    private TableSortState pendingSortState;
    private TableSortState sortState;
    private boolean isSortPending;
    protected boolean hasEverSorted;
    private WeakSet<SortListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public AbstractSortedTableModel() {
        this(0);
    }

    public AbstractSortedTableModel(int defaultSortColumn) {
        this.setDefaultTableSortState(TableSortState.createDefaultSortState(defaultSortColumn));
    }

    protected void setDefaultTableSortState(TableSortState defaultSortState) {
        this.sortState = defaultSortState;
    }

    @Override
    public void addSortListener(SortListener l) {
        this.listeners.add((Object)l);
    }

    @Override
    public T getRowObject(int viewRow) {
        List data = this.getModelData();
        if (viewRow < 0 || viewRow >= data.size()) {
            return null;
        }
        return data.get(viewRow);
    }

    @Override
    public int getRowIndex(T rowObject) {
        if (rowObject == null) {
            return -1;
        }
        return this.getIndexForRowObject(rowObject);
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        this.reSort();
    }

    protected void reSort() {
        List modelData = this.getModelData();
        if (modelData == null || modelData.isEmpty()) {
            return;
        }
        this.pendingSortState = this.sortState;
        this.sort(modelData, new TableSortingContext<T>(this.sortState, this.getComparatorChain(this.sortState)));
    }

    @Override
    public TableSortState getTableSortState() {
        return this.sortState;
    }

    @Override
    public int getPrimarySortColumnIndex() {
        return this.sortState.iterator().next().getColumnModelIndex();
    }

    @Override
    public void setTableSortState(TableSortState newSortState) {
        if (!this.isValidSortState(newSortState)) {
            throw new IllegalArgumentException("Unable to sort the table by the given sort state!: " + newSortState);
        }
        this.doSetTableSortState(newSortState);
    }

    private boolean isValidSortState(TableSortState tableSortState) {
        int columnCount = this.getColumnCount();
        int sortedColumnCount = tableSortState.getSortedColumnCount();
        if (sortedColumnCount > columnCount) {
            return false;
        }
        for (int i = 0; i < columnCount; ++i) {
            ColumnSortState state = tableSortState.getColumnSortState(i);
            if (state == null || this.isSortable(i)) continue;
            return false;
        }
        return true;
    }

    private void doSetTableSortState(TableSortState newSortState) {
        if (newSortState.equals(this.pendingSortState)) {
            return;
        }
        if (newSortState.equals(this.sortState) && this.pendingSortState == null) {
            return;
        }
        this.isSortPending = true;
        this.pendingSortState = newSortState;
        SwingUtilities.invokeLater(() -> this.sort(this.getModelData(), this.createSortingContext(newSortState)));
    }

    public TableSortState getPendingSortState() {
        return this.pendingSortState;
    }

    public boolean isSortPending() {
        return this.isSortPending;
    }

    protected TableSortingContext<T> createSortingContext(TableSortState newSortState) {
        return new TableSortingContext<T>(newSortState, this.getComparatorChain(newSortState));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.initializeSorting();
        return super.getValueAt(rowIndex, columnIndex);
    }

    protected void initializeSorting() {
        if (this.hasEverSorted) {
            return;
        }
        this.hasEverSorted = true;
        this.isSortPending = true;
        this.pendingSortState = this.sortState;
        SwingUtilities.invokeLater(() -> this.sort(this.getModelData(), this.createSortingContext(this.sortState)));
    }

    @Override
    protected int getIndexForRowObject(T rowObject) {
        return this.getIndexForRowObject(rowObject, this.getModelData());
    }

    @Override
    protected int getIndexForRowObject(T rowObject, List<T> data) {
        Comparator<T> comparator = this.getComparatorChain(this.sortState);
        return Collections.binarySearch(data, rowObject, comparator);
    }

    protected void sort(List<T> data, TableSortingContext<T> sortingContext) {
        this.hasEverSorted = true;
        Collections.sort(data, sortingContext.getComparator());
        this.sortCompleted(sortingContext);
        this.notifyModelSorted(false);
    }

    protected void sortCompleted(TableSortingContext<T> sortingContext) {
        if (sortingContext != null) {
            this.sortState = sortingContext.getSortState();
        }
        this.isSortPending = false;
        this.pendingSortState = null;
    }

    protected void notifyModelSorted(boolean dataChanged) {
        if (dataChanged) {
            super.fireTableChanged(new TableModelEvent(this));
        } else {
            super.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 0));
        }
        for (SortListener listener : this.listeners) {
            listener.modelSorted(this.sortState);
        }
    }

    protected Comparator<T> createSortComparator(int columnIndex) {
        return new DefaultColumnComparator(columnIndex);
    }

    private Comparator<T> createLastResortComparator(ComparatorLink parentChain) {
        Comparator endOfChain = new EndOfChainComparator();
        if (parentChain.primaryComparator instanceof ReverseComparator) {
            endOfChain = new ReverseComparator(endOfChain);
        }
        return endOfChain;
    }

    private Comparator<T> getComparatorChain(TableSortState newSortState) {
        ComparatorLink comparatorLink = new ComparatorLink();
        for (ColumnSortState columnSortState : newSortState) {
            Comparator<T> nextComparator = this.getComparator(columnSortState);
            comparatorLink.add(nextComparator);
        }
        comparatorLink.add(this.createLastResortComparator(comparatorLink));
        return comparatorLink;
    }

    private Comparator<T> getComparator(ColumnSortState columnSortState) {
        Comparator<T> comparator = this.createSortComparator(columnSortState.getColumnModelIndex());
        if (columnSortState.isAscending()) {
            return comparator;
        }
        return new ReverseComparator(comparator);
    }

    private class DefaultColumnComparator
    implements Comparator<T> {
        private final int columnIndex;

        public DefaultColumnComparator(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(T t1, T t2) {
            Object value1 = AbstractSortedTableModel.this.getColumnValueForRow(t1, this.columnIndex);
            Object value2 = AbstractSortedTableModel.this.getColumnValueForRow(t2, this.columnIndex);
            return SortedTableModel.DEFAULT_COMPARATOR.compare(value1, value2);
        }
    }

    private class ReverseComparator
    implements Comparator<T> {
        private final Comparator<T> comparator;

        public ReverseComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T t1, T t2) {
            return -this.comparator.compare(t1, t2);
        }
    }

    private class EndOfChainComparator
    implements Comparator<T> {
        private EndOfChainComparator() {
        }

        @Override
        public int compare(T t1, T t2) {
            if (t1 instanceof Comparable) {
                return ((Comparable)t1).compareTo(t2);
            }
            return System.identityHashCode(t1) - System.identityHashCode(t2);
        }
    }

    private class ComparatorLink
    implements Comparator<T> {
        private Comparator<T> primaryComparator;
        private Comparator<T> nextComparator;

        public ComparatorLink() {
        }

        private ComparatorLink(Comparator<T> firstLink, Comparator<T> nextLink) {
            this.primaryComparator = firstLink;
            this.nextComparator = nextLink;
        }

        void add(Comparator<T> comparator) {
            if (this.primaryComparator == null) {
                this.primaryComparator = comparator;
            } else {
                this.nextComparator = this.nextComparator == null ? comparator : new ComparatorLink(this.nextComparator, comparator);
            }
        }

        int size() {
            int count = 0;
            if (this.primaryComparator != null) {
                ++count;
            }
            if (this.nextComparator == null) {
                return count;
            }
            if (this.nextComparator instanceof ComparatorLink) {
                count += ((ComparatorLink)this.nextComparator).size();
            }
            return count + 1;
        }

        @Override
        public int compare(T t1, T t2) {
            int result = this.primaryComparator.compare(t1, t2);
            if (result != 0 || this.nextComparator == null) {
                return result;
            }
            result = this.nextComparator.compare(t1, t2);
            return result;
        }
    }
}

