/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.filter.MultitermEvaluationMode;
import docking.widgets.filter.TextFilter;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.TableFilter;
import java.util.List;

public class MultiTextFilterTableFilter<ROW_OBJECT>
implements TableFilter<ROW_OBJECT> {
    private final List<TextFilter> filters;
    private final String text;
    private final RowFilterTransformer<ROW_OBJECT> transformer;
    private final MultitermEvaluationMode evalMode;

    public MultiTextFilterTableFilter(String text, List<TextFilter> filters, RowFilterTransformer<ROW_OBJECT> transformer, MultitermEvaluationMode evalMode) {
        this.text = text;
        this.filters = filters;
        this.transformer = transformer;
        this.evalMode = evalMode;
    }

    @Override
    public boolean isSubFilterOf(TableFilter<?> tableFilter) {
        if (!(tableFilter instanceof MultiTextFilterTableFilter)) {
            return false;
        }
        MultiTextFilterTableFilter other = (MultiTextFilterTableFilter)tableFilter;
        if (this.filters.size() != other.filters.size()) {
            return false;
        }
        for (int i = 0; i < this.filters.size(); ++i) {
            TextFilter otherFilter;
            TextFilter filter = this.filters.get(i);
            if (filter.isSubFilterOf(otherFilter = other.filters.get(i))) continue;
            return false;
        }
        Class<?> clazz = this.transformer.getClass();
        Class<?> otherClazz = other.transformer.getClass();
        return clazz.equals(otherClazz);
    }

    @Override
    public boolean acceptsRow(ROW_OBJECT rowObject) {
        if (this.filters.isEmpty()) {
            return true;
        }
        List<String> columnData = this.transformer.transform(rowObject);
        if (this.evalMode == MultitermEvaluationMode.AND) {
            return this.filters.parallelStream().map(f -> MultiTextFilterTableFilter.matches(f, columnData)).allMatch(m -> m == true);
        }
        return this.filters.parallelStream().map(f -> MultiTextFilterTableFilter.matches(f, columnData)).anyMatch(m -> m == true);
    }

    private static boolean matches(TextFilter filter, List<String> columnData) {
        return columnData.parallelStream().map(data -> filter.matches((String)data)).anyMatch(r -> r == true);
    }
}

