/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.AddRemoveJob;
import docking.widgets.table.threaded.FilterJob;
import docking.widgets.table.threaded.LoadJob;
import docking.widgets.table.threaded.LoadSpecificDataJob;
import docking.widgets.table.threaded.SortJob;
import docking.widgets.table.threaded.TableData;
import docking.widgets.table.threaded.TableUpdateJob;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.concurrent.ConcurrentListenerSet;
import ghidra.util.SystemUtilities;
import ghidra.util.task.DummyCancellableTaskMonitor;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

class ThreadedTableModelUpdateMgr<T> {
    static final int TOO_MANY_ADD_REMOVES = 3000;
    public static final int DELAY = 1000;
    public static final int MAX_DELAY = 1200000;
    private ThreadedTableModel<T, ?> model;
    private SwingUpdateManager updateManager;
    private TaskMonitor monitor;
    private ConcurrentListenerSet<ThreadedTableModelListener> listeners = new ConcurrentListenerSet();
    private TableUpdateJob<T> pendingJob;
    private TableUpdateJob<T> currentJob;
    private Thread thread;
    private List<AddRemoveListItem<T>> addRemoveWaitList = new ArrayList<AddRemoveListItem<T>>();
    private final int maxAddRemoveCount;
    private Runnable notifyPending;
    private Runnable notifyUpdating;
    private Runnable notifyDone;
    private Runnable notifyCancelled;
    private Runnable threadRunnable = new ThreadRunnable();

    ThreadedTableModelUpdateMgr(ThreadedTableModel<T, ?> threadedTableModel, TaskMonitor monitor) {
        this.model = threadedTableModel;
        this.monitor = this.validateMonitor(monitor);
        this.maxAddRemoveCount = 3000;
        SystemUtilities.assertTrue((boolean)this.monitor.isCancelEnabled(), (String)"In order for this update manager to work correctly the given task monitor must be cancel enabled (e.g., you cannot use the TaskMonitorAdapter.DUMMY_MONITOR, as that is not cancelleable)");
        this.updateManager = new SwingUpdateManager(1000, 1200000, () -> this.processAddRemoveItems());
        this.notifyPending = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadPending();
            }
        };
        this.notifyUpdating = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingStarted();
            }
        };
        this.notifyDone = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingFinished(false);
            }
        };
        this.notifyCancelled = () -> {
            for (ThreadedTableModelListener listener : this.listeners) {
                listener.loadingFinished(true);
            }
        };
    }

    private TaskMonitor validateMonitor(TaskMonitor clientMonitor) {
        if (clientMonitor != null && clientMonitor.isCancelEnabled()) {
            return clientMonitor;
        }
        return new DummyCancellableTaskMonitor();
    }

    Object getSynchronizingLock() {
        return this.updateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddRemoveItems() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            if (this.addRemoveWaitList.isEmpty()) {
                return;
            }
            if (this.addRemoveWaitList.size() > this.maxAddRemoveCount) {
                this.reload();
                return;
            }
            this.pendingJob = new AddRemoveJob<T>(this.model, this.addRemoveWaitList, this.monitor);
            this.addRemoveWaitList = new ArrayList<AddRemoveListItem<T>>();
            this.runJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            if (this.thread != null) {
                return;
            }
            if (this.pendingJob == null) {
                return;
            }
            this.thread = new Thread(this.threadRunnable, "Threaded Table Model Update Manager: " + this.model.getName());
            this.thread.start();
            SwingUtilities.invokeLater(this.notifyUpdating);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllJobs() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            this.updateManager.stop();
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.pendingJob = null;
            this.addRemoveWaitList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            this.cancelAllJobs();
            this.pendingJob = new LoadJob<T>(this.model, this.monitor);
            this.runJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadSpecificData(List<T> data) {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            this.cancelAllJobs();
            TableData<T> tableData = TableData.createFullDataset(data);
            this.pendingJob = new LoadSpecificDataJob<T>(this.model, this.monitor, tableData);
            this.runJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sort(TableSortingContext<T> sortingContext, boolean forceSort) {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            if (this.currentJob != null && this.pendingJob == null && this.currentJob.sort(sortingContext, forceSort)) {
                return;
            }
            if (this.pendingJob != null) {
                this.pendingJob.sort(sortingContext, forceSort);
            } else {
                this.pendingJob = new SortJob<T>(this.model, this.monitor, sortingContext, forceSort);
                this.runJob();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filter() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            if (this.currentJob != null && this.pendingJob == null && this.currentJob.filter()) {
                return;
            }
            if (this.pendingJob != null) {
                this.pendingJob.filter();
            } else {
                this.pendingJob = new FilterJob<T>(this.model, this.monitor);
                this.runJob();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRemove(AddRemoveListItem<T> item) {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            if (this.pendingJob != null) {
                this.pendingJob.addRemove(item, this.maxAddRemoveCount);
                return;
            }
            if (this.addRemoveWaitList.size() > this.maxAddRemoveCount) {
                this.reload();
                return;
            }
            if (this.addRemoveWaitList.isEmpty() && this.thread == null) {
                SwingUtilities.invokeLater(this.notifyPending);
            }
            this.addRemoveWaitList.add(item);
            this.updateManager.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBusy() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            return this.thread != null || this.pendingJob != null || this.updateManager.isBusy() || !this.addRemoveWaitList.isEmpty();
        }
    }

    void setUpdateDelay(int updateDelayMillis, int maxUpdateDelayMillis) {
        this.updateManager.dispose();
        this.updateManager = new SwingUpdateManager(updateDelayMillis, maxUpdateDelayMillis, () -> this.processAddRemoveItems());
    }

    void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    TaskMonitor getTaskMonitor() {
        return this.monitor;
    }

    void addThreadedTableListener(ThreadedTableModelListener listener) {
        this.listeners.add((Object)listener);
    }

    void removeThreadedTableListener(ThreadedTableModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            this.listeners.clear();
            this.monitor.cancel();
            this.monitor = new PermantentlyCancelledMonitor();
            this.cancelAllJobs();
            this.updateManager.dispose();
        }
    }

    public void updateNow() {
        this.updateManager.updateNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableUpdateJob<T> getNextJob() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            this.currentJob = this.pendingJob;
            this.pendingJob = null;
            return this.currentJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobDone() {
        SwingUpdateManager swingUpdateManager = this.updateManager;
        synchronized (swingUpdateManager) {
            boolean isCancelled = this.monitor.isCancelled();
            if (isCancelled) {
                SwingUtilities.invokeLater(this.notifyCancelled);
            } else {
                SwingUtilities.invokeLater(this.notifyDone);
            }
            this.thread = null;
            if (!this.addRemoveWaitList.isEmpty()) {
                SwingUtilities.invokeLater(this.notifyPending);
            }
        }
    }

    private class PermantentlyCancelledMonitor
    extends TaskMonitorAdapter {
        public PermantentlyCancelledMonitor() {
            this.setCancelEnabled(true);
            this.cancel();
        }

        public void clearCanceled() {
        }
    }

    class ThreadRunnable
    implements Runnable {
        ThreadRunnable() {
        }

        @Override
        public void run() {
            TableUpdateJob job = ThreadedTableModelUpdateMgr.this.getNextJob();
            while (job != null) {
                ThreadedTableModelUpdateMgr.this.monitor.clearCanceled();
                job.run();
                job = ThreadedTableModelUpdateMgr.this.getNextJob();
            }
            ThreadedTableModelUpdateMgr.this.jobDone();
        }
    }
}

