/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.MDVoidDataType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.extended.MDExtendedType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.template.MDTemplateConstant;

public class MDTemplateArgumentsList
extends MDParsableItem {
    private List<MDDataType> args = new ArrayList<MDDataType>();
    private List<Boolean> commaDelimiter = new ArrayList<Boolean>();

    public MDTemplateArgumentsList(MDMang dmang) {
        super(dmang);
    }

    public int getNumArgs() {
        return this.args.size();
    }

    public MDDataType getArg(int index) {
        return this.args.get(index);
    }

    @Override
    protected void parseInternal() throws MDException {
        boolean argsDone = false;
        boolean needsComma = false;
        block9: while (!argsDone) {
            char code = this.dmang.peek();
            switch (code) {
                case '@': {
                    this.dmang.increment();
                    argsDone = true;
                    break;
                }
                case '\uffff': {
                    argsDone = true;
                    break;
                }
                case 'X': {
                    this.dmang.increment();
                    MDDataType dt = new MDVoidDataType(this.dmang);
                    dt.parse();
                    this.commaDelimiter.add(needsComma);
                    needsComma = true;
                    this.args.add(dt);
                    break;
                }
                case 'Z': {
                    throw new MDException("Varargs not allowed as template parameter");
                }
                case '?': {
                    this.dmang.increment();
                    MDEncodedNumber x = new MDEncodedNumber(this.dmang);
                    x.parse();
                    MDDataType datatype = new MDDataType(this.dmang);
                    datatype.setTypeName("`template-parameter-" + x + "'");
                    MDDataType dt = datatype;
                    this.commaDelimiter.add(needsComma);
                    needsComma = true;
                    this.args.add(dt);
                    this.dmang.addBackrefTemplateParameterMDDataType(dt);
                    break;
                }
                case '$': {
                    MDDataType dt;
                    if (this.dmang.peek(1) == '$' && this.dmang.peek(2) == '$' && this.dmang.peek(3) == 'V') {
                        this.dmang.increment();
                        this.dmang.increment();
                        this.dmang.increment();
                        this.dmang.increment();
                        if (!this.args.isEmpty()) continue block9;
                        needsComma = this.dmang.emptyFirstArgComma(this);
                        continue block9;
                    }
                    if (this.dmang.peek(1) == '$') {
                        dt = MDDataTypeParser.parsePrimaryDataType(this.dmang, true);
                        dt.parse();
                        this.commaDelimiter.add(needsComma);
                        needsComma = true;
                        this.args.add(dt);
                        if (!(dt instanceof MDModifierType) && !(dt instanceof MDExtendedType) && !(dt instanceof MDComplexType)) continue block9;
                        this.dmang.addBackrefTemplateParameterMDDataType(dt);
                        break;
                    }
                    MDTemplateConstant tp = new MDTemplateConstant(this.dmang);
                    tp.parse();
                    StringBuilder tmpBuilder = new StringBuilder();
                    tp.insert(tmpBuilder);
                    String tpName = tmpBuilder.toString();
                    if (!tpName.isEmpty()) {
                        MDDataType datatype = new MDDataType(this.dmang);
                        datatype.setTypeName(tpName);
                        dt = datatype;
                        this.commaDelimiter.add(needsComma);
                        needsComma = true;
                        this.args.add(dt);
                        this.dmang.addBackrefTemplateParameterMDDataType(dt);
                        break;
                    }
                    if (!this.args.isEmpty()) continue block9;
                    needsComma = this.dmang.emptyFirstArgComma(this);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.dmang.increment();
                    int index = code - 48;
                    MDDataType dt = this.dmang.getBackreferenceTemplateParameterMDDataType(index);
                    this.commaDelimiter.add(this.dmang.templateBackrefComma(this));
                    needsComma = true;
                    this.args.add(dt);
                    break;
                }
                default: {
                    MDDataType dt = MDDataTypeParser.parsePrimaryDataType(this.dmang, true);
                    dt.parse();
                    this.commaDelimiter.add(needsComma);
                    needsComma = true;
                    this.args.add(dt);
                    if (!(dt instanceof MDModifierType) && !(dt instanceof MDExtendedType) && !(dt instanceof MDComplexType)) continue block9;
                    this.dmang.addBackrefTemplateParameterMDDataType(dt);
                }
            }
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.args.size() > 0) {
            Iterator<Boolean> delimIter = this.commaDelimiter.iterator();
            for (MDType mDType : this.args) {
                if (delimIter.next().booleanValue()) {
                    this.dmang.appendString(builder, ",");
                }
                StringBuilder argBuilder = new StringBuilder();
                mDType.insert(argBuilder);
                this.dmang.appendString(builder, argBuilder.toString());
            }
        }
    }
}

