/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;
import org.jf.dexlib.Util.Utf8Utils;

public class StringDataItem
extends Item<StringDataItem> {
    private int hashCode = 0;
    private String stringValue;

    protected StringDataItem(DexFile dexFile) {
        super(dexFile);
    }

    private StringDataItem(DexFile dexFile, String stringValue) {
        super(dexFile);
        this.stringValue = stringValue;
    }

    public static StringDataItem internStringDataItem(DexFile dexFile, String value) {
        StringDataItem StringDataItem2 = new StringDataItem(dexFile, value);
        return dexFile.StringDataSection.intern(StringDataItem2);
    }

    public static StringDataItem lookupStringDataItem(DexFile dexFile, String value) {
        StringDataItem StringDataItem2 = new StringDataItem(dexFile, value);
        return dexFile.StringDataSection.getInternedItem(StringDataItem2);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        in.readUnsignedLeb128();
        this.stringValue = in.realNullTerminatedUtf8String();
    }

    @Override
    protected int placeItem(int offset) {
        return offset + Leb128Utils.unsignedLeb128Size(this.stringValue.length()) + Utf8Utils.stringToUtf8Bytes(this.stringValue).length + 1;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        byte[] encodedValue = Utf8Utils.stringToUtf8Bytes(this.stringValue);
        if (out.annotates()) {
            out.annotate("string_size: 0x" + Integer.toHexString(this.stringValue.length()) + " (" + this.stringValue.length() + ")");
            out.writeUnsignedLeb128(this.stringValue.length());
            out.annotate(encodedValue.length + 1, "string_data: \"" + Utf8Utils.escapeString(this.stringValue) + "\"");
        } else {
            out.writeUnsignedLeb128(this.stringValue.length());
        }
        out.write(encodedValue);
        out.writeByte(0);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_STRING_DATA_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "string_data_item: \"" + Utf8Utils.escapeString(this.getStringValue()) + "\"";
    }

    @Override
    public int compareTo(StringDataItem o) {
        return this.getStringValue().compareTo(o.getStringValue());
    }

    public String getStringValue() {
        return this.stringValue;
    }

    private void calcHashCode() {
        this.hashCode = this.getStringValue().hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        StringDataItem other = (StringDataItem)o;
        return this.getStringValue().equals(other.getStringValue());
    }
}

