/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.remote.RepositoryChangeEvent;
import ghidra.framework.store.FileSystemListener;
import java.io.InterruptedIOException;

class RepositoryChangeDispatcher
implements Runnable {
    private FileSystemListener changeListener;
    private RepositoryAdapter repAdapter;
    private volatile Thread thread;

    RepositoryChangeDispatcher(RepositoryAdapter repAdapter) {
        this.repAdapter = repAdapter;
    }

    @Override
    public void run() {
        try {
            while (this.thread != null) {
                this.processEvents(this.repAdapter.getEvents());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    public void setFileChangeListener(FileSystemListener changeListener) {
        this.changeListener = changeListener;
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public synchronized void start() {
        this.stop();
        this.thread = new Thread((Runnable)this, "RepChangeDispatcher-" + this.repAdapter.getName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void processEvents(RepositoryChangeEvent[] events) {
        if (this.changeListener == null) {
            return;
        }
        block12: for (int i = 0; this.thread != null && i < events.length; ++i) {
            RepositoryChangeEvent event = events[i];
            switch (event.type) {
                case 9: {
                    this.repAdapter.processOpenHandleCountUpdateEvent(event);
                    continue block12;
                }
                case 0: {
                    this.changeListener.folderCreated(event.parentPath, event.name);
                    continue block12;
                }
                case 2: {
                    this.changeListener.folderDeleted(event.parentPath, event.name);
                    continue block12;
                }
                case 3: {
                    this.changeListener.folderMoved(event.parentPath, event.name, event.newParentPath);
                    continue block12;
                }
                case 4: {
                    this.changeListener.folderRenamed(event.parentPath, event.name, event.newName);
                    continue block12;
                }
                case 8: {
                    this.changeListener.itemChanged(event.parentPath, event.name);
                    continue block12;
                }
                case 1: {
                    this.changeListener.itemCreated(event.parentPath, event.name);
                    continue block12;
                }
                case 5: {
                    this.changeListener.itemDeleted(event.parentPath, event.name);
                    continue block12;
                }
                case 7: {
                    this.changeListener.itemMoved(event.parentPath, event.name, event.newParentPath, event.newName);
                    continue block12;
                }
                case 6: {
                    this.changeListener.itemRenamed(event.parentPath, event.name, event.newName);
                }
            }
        }
    }
}

