/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import generic.jar.ClassModuleTree;
import generic.jar.ResourceFile;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GModule;
import ghidra.framework.LoggingInitialization;
import ghidra.framework.Platform;
import ghidra.util.ErrorDisplay;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.datastruct.LRUMap;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utilities.util.reflection.ReflectionUtilities;
import utility.application.ApplicationLayout;
import utility.module.ModuleUtilities;

public class Application {
    private static final String JAR_EXTENSION = ".jar";
    private static final String DATA_DIRNAME = "data/";
    private static Application app;
    private static Throwable firstCreationThrowable;
    private ApplicationLayout layout;
    private ApplicationConfiguration configuration;
    private ClassModuleTree classModuleTree;
    private boolean loggingInitialized;
    private Map<String, List<ResourceFile>> fileExtensionCache = new LRUMap<String, List<ResourceFile>>(5);

    private Application(ApplicationLayout layout, ApplicationConfiguration configuration) {
        this.layout = layout;
        this.configuration = configuration;
    }

    private void initialize() {
        try {
            this.layout.createUserDirs();
        }
        catch (IOException e) {
            throw new AssertException(e.getMessage());
        }
        String isHeadless = Boolean.toString(this.configuration.isHeadless());
        System.setProperty("SystemUtilities.isHeadless", isHeadless);
        System.setProperty("java.awt.headless", isHeadless);
        System.setProperty("SystemUtilities.isSingleJarMode", Boolean.toString(this.layout.inSingleJarMode()));
        UniversalIdGenerator.initialize();
        this.initializeLogging();
        this.installStaticFactories();
        Msg.setErrorDisplay((ErrorDisplay)this.configuration.getErrorDisplay());
    }

    public static void initializeApplication(ApplicationLayout layout, ApplicationConfiguration configuration) {
        if (app != null) {
            throw new AssertException("Attempted to initialize the application more than once!", firstCreationThrowable);
        }
        app = new Application(layout, configuration);
        app.initialize();
        configuration.initializeApplication();
        firstCreationThrowable = new AssertException("First call to initialize Application...");
    }

    public static boolean isInitialized() {
        return app != null;
    }

    private void installStaticFactories() {
        TaskMonitor monitor = this.configuration.getTaskMonitor();
        monitor.setMessage("Installing static factories...");
        this.configuration.installStaticFactories();
    }

    private void initializeLogging() {
        if (this.configuration.isInitializeLogging()) {
            TaskMonitor monitor = this.configuration.getTaskMonitor();
            monitor.setMessage("Initializing logging system...");
            Application.initializeLogging(this.configuration.getApplicationLogFile(), this.configuration.getScriptLogFile());
        }
    }

    public static void initializeLogging(File logFile, File scriptLogFile) {
        Application.checkAppInitialized();
        if (Application.app.loggingInitialized) {
            throw new AssertException("Application logging has already been initialized");
        }
        Application.app.loggingInitialized = true;
        if (logFile == null) {
            logFile = new File(Application.app.layout.getUserSettingsDir(), "application.log");
        }
        if (scriptLogFile == null) {
            scriptLogFile = logFile;
        }
        LoggingInitialization.setApplicationLogFile(logFile);
        LoggingInitialization.setScriptLogFile(scriptLogFile);
        LoggingInitialization.initializeLoggingSystem();
    }

    public static ApplicationLayout getApplicationLayout() {
        Application.checkAppInitialized();
        return Application.app.layout;
    }

    private GModule getModuleFromTreeMap(String className) {
        if (Application.app.classModuleTree == null) {
            ResourceFile rootDir = (ResourceFile)Application.app.layout.getApplicationRootDirs().iterator().next();
            ResourceFile ModuleClassMapFile = new ResourceFile(rootDir, "classModuleTree");
            try {
                Application.app.classModuleTree = new ClassModuleTree(ModuleClassMapFile);
            }
            catch (IOException e) {
                throw new AssertException("Can't find module for " + className);
            }
        }
        String moduleName = Application.app.classModuleTree.getModuleName(className);
        return (GModule)Application.app.layout.getModules().get(moduleName);
    }

    public static ResourceFile getModuleContainingResourceFile(ResourceFile file) {
        while (file != null) {
            if (ModuleUtilities.isModuleDirectory((ResourceFile)file)) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    public static ResourceFile getModuleContainingClass(String className) {
        return app.getModuleForClass(className);
    }

    private void findJavaSourceDirectories(List<ResourceFile> list, ResourceFile moduleRootDirectory) {
        ResourceFile srcDir = new ResourceFile(moduleRootDirectory, "src");
        if (!srcDir.isDirectory()) {
            return;
        }
        for (ResourceFile file : srcDir.listFiles()) {
            ResourceFile javaDir;
            if (!file.isDirectory() || !(javaDir = new ResourceFile(file, "java")).isDirectory()) continue;
            list.add(javaDir);
        }
    }

    private ResourceFile findModuleForJavaSource(String sourcePath) {
        ArrayList<ResourceFile> javaSrcDirectories = new ArrayList<ResourceFile>();
        Collection<ResourceFile> moduleRootDirectories = Application.getModuleRootDirectories();
        for (ResourceFile moduleDirectory : moduleRootDirectories) {
            javaSrcDirectories.clear();
            this.findJavaSourceDirectories(javaSrcDirectories, moduleDirectory);
            for (ResourceFile javaSrcDir : javaSrcDirectories) {
                ResourceFile child = new ResourceFile(javaSrcDir, sourcePath);
                if (!child.exists()) continue;
                return moduleDirectory;
            }
        }
        return null;
    }

    private ResourceFile getModuleForClass(String className) {
        Class<?> callersClass;
        int dollar = className.indexOf(36);
        if (dollar != -1) {
            className = className.substring(0, dollar);
        }
        String path = className.replace('.', '/');
        String sourcePath = path + ".java";
        String classFilePath = path + ".class";
        if (Application.inSingleJarMode()) {
            GModule gModule = this.getModuleFromTreeMap(classFilePath);
            return gModule == null ? null : gModule.getModuleRoot();
        }
        try {
            callersClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        File sourceLocationForClass = SystemUtilities.getSourceLocationForClass(callersClass);
        if (sourceLocationForClass.isDirectory()) {
            return this.findModuleForJavaSource(sourcePath);
        }
        SystemUtilities.assertTrue((boolean)sourceLocationForClass.getName().endsWith(JAR_EXTENSION), (String)("Expected jar file but got: " + sourceLocationForClass.getAbsolutePath()));
        File moduleDirectory = sourceLocationForClass.getParentFile().getParentFile();
        if ("build".equals(moduleDirectory.getName())) {
            moduleDirectory = moduleDirectory.getParentFile();
        }
        return new ResourceFile(moduleDirectory);
    }

    private List<ResourceFile> findFilesByExtension(String extension) {
        List<ResourceFile> list = this.fileExtensionCache.get(extension);
        if (list != null) {
            return list;
        }
        extension = this.verifyExtension(extension);
        list = new ArrayList<ResourceFile>();
        for (GModule module : Application.app.layout.getModules().values()) {
            module.accumulateDataFilesByExtension(list, extension);
        }
        this.fileExtensionCache.put(extension, list);
        return list;
    }

    private ResourceFile findModuleDataFile(String relativePath) {
        String dataFilePath = DATA_DIRNAME + relativePath;
        for (GModule module : Application.app.layout.getModules().values()) {
            ResourceFile foundFile = module.findModuleFile(dataFilePath);
            if (foundFile == null) continue;
            return foundFile;
        }
        return null;
    }

    private List<ResourceFile> findFilesByExtensionInModule(String moduleName, String extension) throws IllegalArgumentException {
        extension = this.verifyExtension(extension);
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>();
        GModule gModule = (GModule)Application.app.layout.getModules().get(moduleName);
        if (gModule != null) {
            gModule.accumulateDataFilesByExtension(list, extension);
        }
        return list;
    }

    private List<ResourceFile> findModuleDirectories(String relativePath) {
        ArrayList<ResourceFile> result = new ArrayList<ResourceFile>();
        for (GModule module : Application.app.layout.getModules().values()) {
            module.collectExistingModuleDirs(result, relativePath);
        }
        return result;
    }

    private ResourceFile getDataFileInModule(String relativeDataPath, String moduleName) throws FileNotFoundException {
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        if (module == null) {
            throw new FileNotFoundException("module not found: " + moduleName);
        }
        ResourceFile foundFile = module.findModuleFile(DATA_DIRNAME + relativeDataPath);
        if (foundFile == null) {
            throw new FileNotFoundException("file " + relativeDataPath + " does not exist in module " + moduleName);
        }
        if (foundFile.isDirectory()) {
            throw new FileNotFoundException(foundFile.getAbsolutePath() + " is a directory (expecting file)");
        }
        return foundFile;
    }

    private ResourceFile getFileInModule(String relativePath, String moduleName) throws FileNotFoundException {
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        if (module == null) {
            throw new FileNotFoundException("module not found: " + moduleName);
        }
        ResourceFile foundFile = module.findModuleFile(relativePath);
        if (foundFile == null) {
            throw new FileNotFoundException("file " + relativePath + " does not exist in module " + moduleName);
        }
        if (foundFile.isDirectory()) {
            throw new FileNotFoundException(foundFile.getAbsolutePath() + " is a directory (expecting file)");
        }
        return foundFile;
    }

    private static void checkAppInitialized() {
        if (app == null) {
            throw new AssertException("\nYou must call Application.initializeApplication() before calling any static method on Application!\n");
        }
    }

    private ResourceFile getDataSubDirectoryInModule(String relativePath, String moduleName) throws IOException, FileNotFoundException {
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        if (module == null) {
            throw new FileNotFoundException("module not found: " + moduleName);
        }
        String relativeDataFilePath = DATA_DIRNAME + relativePath;
        ResourceFile foundDir = module.findModuleFile(relativeDataFilePath);
        if (foundDir == null) {
            throw new FileNotFoundException(relativeDataFilePath + " does not exist in module " + moduleName);
        }
        if (!foundDir.isDirectory()) {
            throw new IOException(foundDir.getAbsolutePath() + " is a file (expecting directory)");
        }
        return foundDir;
    }

    private ResourceFile getSubDirectoryInModule(String relativePath, String moduleName) throws IOException, FileNotFoundException {
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        if (module == null) {
            throw new FileNotFoundException("module not found: " + moduleName);
        }
        ResourceFile foundDir = module.findModuleFile(relativePath);
        if (foundDir == null) {
            throw new FileNotFoundException(relativePath + " does not exist in module " + moduleName);
        }
        if (!foundDir.isDirectory()) {
            throw new IOException(foundDir.getAbsolutePath() + " is a file (expecting directory)");
        }
        return foundDir;
    }

    private File getModuleFile(GModule module, String subdirPath, String exactFilename) {
        String filePath = subdirPath + "/" + exactFilename;
        ResourceFile foundFile = module.findModuleFile(filePath);
        if (foundFile != null) {
            return foundFile.getFile(true);
        }
        return null;
    }

    private File getModuleOSFile(String exactFilename, String moduleName) {
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        if (module == null) {
            return null;
        }
        File file = this.getModuleFile(module, "build/os/" + Platform.CURRENT_PLATFORM.getDirectoryName(), exactFilename);
        if (file == null) {
            file = this.getModuleFile(module, "os/" + Platform.CURRENT_PLATFORM.getDirectoryName(), exactFilename);
        }
        if (file == null && Platform.CURRENT_PLATFORM == Platform.WIN_64) {
            file = this.getModuleFile(module, "build/os/" + Platform.WIN_32.getDirectoryName(), exactFilename);
        }
        if (file == null && Platform.CURRENT_PLATFORM == Platform.WIN_64) {
            file = this.getModuleFile(module, "os/" + Platform.WIN_32.getDirectoryName(), exactFilename);
        }
        return file;
    }

    private File findModuleFile(String subdirPath, String exactFilename) {
        for (GModule module : Application.app.layout.getModules().values()) {
            File file = this.getModuleFile(module, subdirPath, exactFilename);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private File getOSFileInAnyModule(String path) throws FileNotFoundException {
        File file = this.findModuleFile("build/os/" + Platform.CURRENT_PLATFORM.getDirectoryName(), path);
        if (file == null) {
            file = this.findModuleFile("os/" + Platform.CURRENT_PLATFORM.getDirectoryName(), path);
        }
        if (file == null && Platform.CURRENT_PLATFORM == Platform.WIN_64) {
            file = this.findModuleFile("build/os/" + Platform.WIN_32.getDirectoryName(), path);
        }
        if (file == null && Platform.CURRENT_PLATFORM == Platform.WIN_64) {
            file = this.findModuleFile("os/" + Platform.WIN_32.getDirectoryName(), path);
        }
        if (file == null) {
            throw new FileNotFoundException("os/" + Platform.CURRENT_PLATFORM.getDirectoryName() + "/" + path + " does not exist");
        }
        return file;
    }

    private String verifyExtension(String extension) {
        SystemUtilities.assertTrue((!extension.contains("/") ? 1 : 0) != 0, (String)"extension cannot contain / (path separator)");
        SystemUtilities.assertTrue((!extension.contains("\\") ? 1 : 0) != 0, (String)"extension cannot contain \\ (path separator)");
        int dotIndex = extension.indexOf(46);
        SystemUtilities.assertTrue((dotIndex == -1 || dotIndex == 0 ? 1 : 0) != 0, (String)"extension can not contain a \".\" char other than at the beginning");
        return dotIndex == -1 ? "." + extension : extension;
    }

    public static ResourceFile getMyModuleRootDirectory() {
        Application.checkAppInitialized();
        String className = ReflectionUtilities.getClassNameOlderThan((Class[])new Class[]{Application.class});
        return app.getModuleForClass(className);
    }

    public static String getName() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationProperties().getApplicationName();
    }

    public static String getApplicationProperty(String propertyName) {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationProperties().getProperty(propertyName);
    }

    public static Collection<ResourceFile> getApplicationRootDirectories() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationRootDirs();
    }

    public static ResourceFile getApplicationRootDirectory() {
        Application.checkAppInitialized();
        return (ResourceFile)Application.app.layout.getApplicationRootDirs().iterator().next();
    }

    public static File getUserSettingsDirectory() {
        Application.checkAppInitialized();
        return Application.app.layout.getUserSettingsDir();
    }

    public static File getUserTempDirectory() {
        Application.checkAppInitialized();
        return Application.app.layout.getUserTempDir();
    }

    public static File getUserCacheDirectory() {
        Application.checkAppInitialized();
        return Application.app.layout.getUserCacheDir();
    }

    public static Collection<ResourceFile> getModuleRootDirectories() {
        Application.checkAppInitialized();
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>();
        Collection values = Application.app.layout.getModules().values();
        for (GModule gModule : values) {
            list.add(gModule.getModuleRoot());
        }
        return list;
    }

    public static ResourceFile getInstallationDirectory() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationInstallationDir();
    }

    public static ResourceFile getModuleRootDir(String moduleName) {
        Application.checkAppInitialized();
        GModule module = (GModule)Application.app.layout.getModules().get(moduleName);
        return module != null ? module.getModuleRoot() : null;
    }

    public static boolean isTestBuild() {
        Application.checkAppInitialized();
        String value = Application.app.layout.getApplicationProperties().getProperty("application.test.release");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean inSingleJarMode() {
        Application.checkAppInitialized();
        return Application.app.layout.inSingleJarMode();
    }

    public static String getApplicationVersion() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationProperties().getApplicationVersion();
    }

    public static String getBuildDate() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationProperties().getApplicationBuildDate();
    }

    public static String getApplicationReleaseName() {
        Application.checkAppInitialized();
        return Application.app.layout.getApplicationProperties().getProperty("application.release.name");
    }

    public static Map<String, String> getApplicationSourceRevisions() {
        HashMap<String, String> revMap = null;
        Enumeration keys = Application.app.layout.getApplicationProperties().keys();
        while (keys.hasMoreElements()) {
            String keyStr;
            Object key = keys.nextElement();
            if (!(key instanceof String) || !(keyStr = (String)key).startsWith("application.revision.")) continue;
            if (revMap == null) {
                revMap = new HashMap<String, String>();
            }
            revMap.put(keyStr, Application.app.layout.getApplicationProperties().getProperty(keyStr));
        }
        return revMap;
    }

    public static Collection<ResourceFile> getLibraryDirectories() {
        Application.checkAppInitialized();
        return ModuleUtilities.getModuleLibDirectories((Map)Application.app.layout.getModules());
    }

    public static List<ResourceFile> findFilesByExtensionInApplication(String extension) {
        Application.checkAppInitialized();
        return app.findFilesByExtension(extension);
    }

    public static ResourceFile findDataFileInAnyModule(String relativePath) {
        Application.checkAppInitialized();
        return app.findModuleDataFile(relativePath);
    }

    public static List<ResourceFile> findFilesByExtensionInMyModule(String extension) {
        ResourceFile MyModuleDir = Application.getMyModuleRootDirectory();
        if (MyModuleDir == null) {
            return new ArrayList<ResourceFile>();
        }
        return Application.findFilesByExtension(MyModuleDir.getName(), extension);
    }

    public static List<ResourceFile> findFilesByExtension(String moduleName, String extension) throws IllegalArgumentException {
        Application.checkAppInitialized();
        return app.findFilesByExtensionInModule(moduleName, extension);
    }

    public static List<ResourceFile> findModuleSubDirectories(String relativePath) {
        Application.checkAppInitialized();
        return app.findModuleDirectories(relativePath);
    }

    public static ResourceFile getModuleDataSubDirectory(String relativePath) throws FileNotFoundException, IOException {
        Application.checkAppInitialized();
        ResourceFile moduleDirectory = Application.getMyModuleRootDirectory();
        if (moduleDirectory == null) {
            throw new FileNotFoundException("Module root directory not found.");
        }
        return app.getDataSubDirectoryInModule(relativePath, moduleDirectory.getName());
    }

    public static ResourceFile getModuleDataSubDirectory(String moduleName, String relativePath) throws FileNotFoundException, IOException {
        Application.checkAppInitialized();
        return app.getDataSubDirectoryInModule(relativePath, moduleName);
    }

    public static ResourceFile getModuleSubDirectory(String moduleName, String relativePath) throws FileNotFoundException, IOException {
        Application.checkAppInitialized();
        return app.getSubDirectoryInModule(relativePath, moduleName);
    }

    public static ResourceFile getModuleDataFile(String relativeDataPath) throws FileNotFoundException {
        ResourceFile moduleDirectory = Application.getMyModuleRootDirectory();
        if (moduleDirectory == null) {
            throw new FileNotFoundException("Module root directory not found.");
        }
        return app.getDataFileInModule(relativeDataPath, moduleDirectory.getName());
    }

    public static ResourceFile getModuleDataFile(String moduleName, String relativeDataPath) throws FileNotFoundException {
        Application.checkAppInitialized();
        return app.getDataFileInModule(relativeDataPath, moduleName);
    }

    public static ResourceFile getModuleFile(String moduleName, String relativePath) throws FileNotFoundException {
        Application.checkAppInitialized();
        return app.getFileInModule(relativePath, moduleName);
    }

    public static File getOSFile(String moduleName, String exactFilename) throws FileNotFoundException {
        File osFile = app.getModuleOSFile(exactFilename, moduleName);
        if (osFile != null) {
            return osFile;
        }
        throw new FileNotFoundException("Could not find file " + exactFilename + " in module " + moduleName);
    }

    public static File getOSFile(String exactFilename) throws FileNotFoundException {
        ResourceFile myModuleRootDirectory = Application.getMyModuleRootDirectory();
        if (myModuleRootDirectory == null) {
            return app.getOSFileInAnyModule(exactFilename);
        }
        File moduleOSFile = app.getModuleOSFile(exactFilename, myModuleRootDirectory.getName());
        if (moduleOSFile != null) {
            return moduleOSFile;
        }
        return app.getOSFileInAnyModule(exactFilename);
    }
}

