/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import generic.jar.ResourceFile;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlAttributeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Verifier;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XmlUtilities {
    private static final String LESS_THAN = "&lt;";
    private static final String GREATER_THAN = "&gt;";
    private static final String APOSTROPHE = "&apos;";
    private static final String QUOTE = "&quot;";
    private static final String AMPERSAND = "&amp;";
    private static final Pattern HEX_DIGIT_PATTERN = Pattern.compile("[&][#][x]([\\da-fA-F]+)[;]");
    public static final String FEATURE_DISALLOW_DTD = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    public static String escapeElementEntities(String xml) {
        StringBuffer buffer = new StringBuffer();
        block7: for (int i = 0; i < xml.length(); ++i) {
            char next = xml.charAt(i);
            if (next < ' ' && next != '\t' && next != '\n' && next != '\r') continue;
            if (next >= '\u007f') {
                buffer.append("&#x");
                buffer.append(Integer.toString(next, 16).toUpperCase());
                buffer.append(";");
                continue;
            }
            switch (next) {
                case '<': {
                    buffer.append(LESS_THAN);
                    continue block7;
                }
                case '>': {
                    buffer.append(GREATER_THAN);
                    continue block7;
                }
                case '\'': {
                    buffer.append(APOSTROPHE);
                    continue block7;
                }
                case '\"': {
                    buffer.append(QUOTE);
                    continue block7;
                }
                case '&': {
                    buffer.append(AMPERSAND);
                    continue block7;
                }
                default: {
                    buffer.append(next);
                }
            }
        }
        return buffer.toString();
    }

    public static String unEscapeElementEntities(String escapedXMLString) {
        Matcher matcher = HEX_DIGIT_PATTERN.matcher(escapedXMLString);
        StringBuffer buffy = new StringBuffer();
        while (matcher.find()) {
            int intValue = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(buffy, Character.toString((char)intValue));
        }
        matcher.appendTail(buffy);
        String unescapedStr = buffy.toString();
        unescapedStr = unescapedStr.replaceAll(LESS_THAN, "<");
        unescapedStr = unescapedStr.replaceAll(GREATER_THAN, ">");
        unescapedStr = unescapedStr.replaceAll(APOSTROPHE, "'");
        unescapedStr = unescapedStr.replaceAll(QUOTE, "\"");
        unescapedStr = unescapedStr.replaceAll(AMPERSAND, "&");
        return unescapedStr;
    }

    public static byte[] xmlToByteArray(Element root) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Document doc = new Document(root);
        GenericXMLOutputter xmlOut = new GenericXMLOutputter();
        try {
            xmlOut.output(doc, os);
            os.close();
            return os.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String toString(Element root) {
        GenericXMLOutputter outputter = new GenericXMLOutputter();
        return outputter.outputString(root);
    }

    public static Element fromString(String s) throws JDOMException, IOException {
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder(false, false);
        try (StringReader r = new StringReader(s);){
            Document doc = sax.build((Reader)r);
            Element element = doc.getRootElement();
            return element;
        }
    }

    public static void writeDocToFile(Document doc, File dest) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        try (FileWriter fw = new FileWriter(dest);){
            outputter.output(doc, (Writer)fw);
        }
    }

    public static Document readDocFromFile(File f) throws JDOMException, IOException {
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder(false, false);
        try (FileReader r = new FileReader(f);){
            Document doc;
            Document document = doc = sax.build((Reader)r);
            return document;
        }
    }

    public static Document readDocFromFile(ResourceFile f) throws JDOMException, IOException {
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder(false, false);
        try (InputStream is = f.getInputStream();){
            Document doc;
            InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);
            Document document = doc = sax.build((Reader)r);
            return document;
        }
    }

    public static Element byteArrayToXml(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder(false, false);
        try {
            return sax.build((InputStream)is).getRootElement();
        }
        catch (Exception e) {
            Msg.error(XmlUtilities.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String parseOverlayName(String addrStr) {
        int index = addrStr.indexOf("::");
        if (index > 0) {
            return addrStr.substring(0, index);
        }
        return null;
    }

    public static int parseInt(String intStr) {
        return (int)XmlUtilities.parseLong(intStr);
    }

    public static int parseInt(String intStr, int defaultValue) throws NumberFormatException {
        return XmlUtilities.parseOptionalBoundedInt(intStr, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int parseOptionalBoundedInt(String intStr, int defaultValue, int minValue, int maxValue) throws NumberFormatException {
        if (intStr != null) {
            long tmp = XmlUtilities.parseLong(intStr);
            if (tmp < (long)minValue || tmp > (long)maxValue) {
                throw new NumberFormatException("Integer value " + tmp + " out of range: [" + minValue + ".." + maxValue + "]");
            }
            return (int)tmp;
        }
        return defaultValue;
    }

    public static int parseBoundedInt(String intStr, int minValue, int maxValue) throws NumberFormatException {
        if (intStr == null || intStr.isEmpty()) {
            throw new NumberFormatException("Missing value");
        }
        long tmp = XmlUtilities.parseLong(intStr);
        if (tmp < (long)minValue || tmp > (long)maxValue) {
            throw new NumberFormatException("Integer value " + tmp + " out of range: [" + minValue + ".." + maxValue + "]");
        }
        return (int)tmp;
    }

    public static int parseBoundedIntAttr(Element ele, String attrName, int minValue, int maxValue) throws NumberFormatException {
        try {
            return XmlUtilities.parseBoundedInt(ele.getAttributeValue(attrName), minValue, maxValue);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Attribute '" + attrName + "' bad value: " + nfe.getMessage() + " in " + XmlUtilities.toString(ele));
        }
    }

    public static int parseOptionalBoundedIntAttr(Element ele, String attrName, int defaultValue, int minValue, int maxValue) throws NumberFormatException {
        String value = ele.getAttributeValue(attrName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return XmlUtilities.parseBoundedInt(value, minValue, maxValue);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Attribute '" + attrName + "' bad value: " + nfe.getMessage() + " in " + XmlUtilities.toString(ele));
        }
    }

    public static long parseLong(String longStr) {
        long val;
        boolean isNegative = longStr.startsWith("-");
        if (isNegative) {
            longStr = longStr.substring(1);
        }
        int radix = 10;
        if (longStr.startsWith("0x")) {
            longStr = longStr.substring(2);
            radix = 16;
        }
        long l = val = radix == 10 ? NumericUtilities.parseLong(longStr) : NumericUtilities.parseHexLong(longStr);
        if (isNegative) {
            val *= -1L;
        }
        return val;
    }

    public static long parseBoundedLong(String longStr, long minValue, long maxValue) throws NumberFormatException {
        if (longStr == null || longStr.isEmpty()) {
            throw new NumberFormatException("Missing value");
        }
        long tmp = XmlUtilities.parseLong(longStr);
        if (tmp < minValue || tmp > maxValue) {
            throw new NumberFormatException("Long value " + tmp + " out of range: [" + minValue + ".." + maxValue + "]");
        }
        return tmp;
    }

    public static long parseBoundedLongAttr(Element ele, String attrName, long minValue, long maxValue) throws NumberFormatException {
        try {
            return XmlUtilities.parseBoundedLong(ele.getAttributeValue(attrName), minValue, maxValue);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Attribute '" + attrName + "' bad value: " + nfe.getMessage() + " in " + XmlUtilities.toString(ele));
        }
    }

    public static long parseOptionalBoundedLongAttr(Element ele, String attrName, long defaultValue, long minValue, long maxValue) throws NumberFormatException {
        String value = ele.getAttributeValue(attrName);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return XmlUtilities.parseBoundedLong(value, minValue, maxValue);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Attribute '" + attrName + "' bad value: " + nfe.getMessage() + " in " + XmlUtilities.toString(ele));
        }
    }

    public static boolean parseBoolean(String boolStr) {
        if (boolStr == null) {
            return false;
        }
        if (!(boolStr.equalsIgnoreCase("y") || boolStr.equalsIgnoreCase("n") || boolStr.equalsIgnoreCase("true") || boolStr.equalsIgnoreCase("false"))) {
            throw new XmlAttributeException(boolStr + " is not a valid boolean (y|n)");
        }
        return "y".equalsIgnoreCase(boolStr) || "true".equalsIgnoreCase(boolStr);
    }

    public static boolean parseOptionalBooleanAttr(Element ele, String attrName, boolean defaultValue) throws IOException {
        String value = ele.getAttributeValue(attrName);
        try {
            return value != null ? XmlUtilities.parseBoolean(value) : defaultValue;
        }
        catch (XmlAttributeException e) {
            throw new IOException("Attribute '" + attrName + "' bad boolean value: '" + value + "' in " + XmlUtilities.toString(ele));
        }
    }

    public static String requireStringAttr(Element ele, String attrName) throws IOException {
        String value = ele.getAttributeValue(attrName);
        if (value == null || value.isEmpty()) {
            throw new IOException("Missing required attribute: '" + attrName + "' in " + XmlUtilities.toString(ele));
        }
        return value;
    }

    public static boolean hasInvalidXMLCharacters(String s) {
        return !s.codePoints().allMatch(Verifier::isXMLCharacter);
    }

    public static SAXBuilder createSecureSAXBuilder(boolean validate, boolean needsDTD) {
        String IMPLNAME = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        SAXBuilder sax = new SAXBuilder("com.sun.org.apache.xerces.internal.parsers.SAXParser", validate);
        sax.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        if (!needsDTD) {
            sax.setFeature(FEATURE_DISALLOW_DTD, true);
        }
        sax.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        sax.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        return sax;
    }

    public static SAXParserFactory createSecureSAXParserFactory(boolean needsDTD) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (!needsDTD) {
                factory.setFeature(FEATURE_DISALLOW_DTD, true);
            }
            factory.setFeature(FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException("Cannot set XML parsing feature for secure processing: ", e);
        }
        return factory;
    }

    public static class ThrowingErrorHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

