/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangXML;
import ghidra.app.decompiler.DecompileProcess;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParamID;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.InputStream;
import org.xml.sax.ErrorHandler;

public class DecompileResults {
    private Function function;
    private Language language;
    private CompilerSpec compilerSpec;
    private PcodeDataTypeManager dtmanage;
    private HighFunction hfunc;
    private HighParamID hparamid;
    private ClangTokenGroup docroot;
    private String errMsg;
    private DecompileProcess.DisposeState processState;
    private boolean showNamespace;

    public DecompileResults(Function f, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager d, String e, InputStream raw, DecompileProcess.DisposeState processState, boolean showNamespace) {
        this.function = f;
        this.language = language;
        this.compilerSpec = compilerSpec;
        this.dtmanage = d;
        this.errMsg = e;
        this.hfunc = null;
        this.hparamid = null;
        this.docroot = null;
        this.showNamespace = showNamespace;
        this.parseRawString(raw);
    }

    public boolean decompileCompleted() {
        return this.hfunc != null || this.hparamid != null;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean isTimedOut() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_TIMEOUT;
    }

    public boolean isCancelled() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_CANCEL;
    }

    public boolean failedToStart() {
        return this.processState == DecompileProcess.DisposeState.DISPOSED_ON_STARTUP_FAILURE;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public HighFunction getHighFunction() {
        return this.hfunc;
    }

    public HighParamID getHighParamID() {
        return this.hparamid;
    }

    public ClangTokenGroup getCCodeMarkup() {
        return this.docroot;
    }

    public DecompiledFunction getDecompiledFunction() {
        if (this.docroot == null) {
            return null;
        }
        PrettyPrinter printer = new PrettyPrinter(this.function, this.docroot);
        return printer.print(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseRawString(InputStream rawxml) {
        if (rawxml == null) {
            return;
        }
        XmlPullParser parser = null;
        try {
            parser = HighFunction.stringTree((InputStream)rawxml, (ErrorHandler)HighFunction.getErrorHandler((Object)this, (String)("decompiler results for function at " + this.function.getEntryPoint())));
            this.hfunc = null;
            this.hparamid = null;
            this.docroot = null;
            parser.start(new String[]{"doc"});
            while (parser.peek().isStart()) {
                XmlElement el = parser.peek();
                if (el.getName().equals("function")) {
                    if (this.hfunc == null) {
                        this.hfunc = new HighFunction(this.function, this.language, this.compilerSpec, this.dtmanage, this.showNamespace);
                        this.hfunc.readXML(parser);
                    } else {
                        this.docroot = ClangXML.buildClangTree(parser, this.hfunc);
                        if (this.docroot == null) {
                            this.errMsg = "Unable to parse C (xml)";
                        }
                    }
                } else if (el.getName().equals("parammeasures")) {
                    this.hparamid = new HighParamID(this.function, this.language, this.compilerSpec, this.dtmanage, this.showNamespace);
                    this.hparamid.readXML(parser);
                } else {
                    this.errMsg = "Unknown decompiler tag: " + el.getName();
                    return;
                }
                try {
                }
                catch (PcodeXMLException e) {
                    this.errMsg = e.getMessage();
                    this.hfunc = null;
                    this.hparamid = null;
                    return;
                }
                catch (RuntimeException e) {
                    this.errMsg = e.getMessage();
                    this.hfunc = null;
                    this.hparamid = null;
                    return;
                }
            }
        }
        finally {
            if (parser != null) {
                parser.dispose();
            }
        }
    }
}

