/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class CloneDecompilerAction
extends DockingAction {
    private final DecompilerProvider provider;
    private DecompilerController controller;

    public CloneDecompilerAction(String owner, DecompilerProvider provider, DecompilerController controller) {
        super("Decompile Clone", owner);
        this.provider = provider;
        this.controller = controller;
        ImageIcon image = ResourceManager.loadImage((String)"images/camera-photo.png");
        this.setToolBarData(new ToolBarData((Icon)image, "ZZZ"));
        this.setDescription("Create a snapshot (disconnected) copy of this Decompiler window ");
        this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
        this.setKeyBindingData(new KeyBindingData(84, 192));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return this.controller.getFunction() != null;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        this.provider.cloneWindow();
    }
}

