/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class EditDataTypeAction
extends DockingAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public EditDataTypeAction(String owner, PluginTool tool, DecompilerController controller) {
        super("EditDataType", owner);
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Edit Data Type..."}, "Decompile"));
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    public boolean isAddToPopup(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return false;
        }
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (variable == null) {
            return false;
        }
        DataType dataType = variable.getDataType();
        if (dataType == null) {
            return false;
        }
        return this.hasCustomEditorForBaseDataType(dataType);
    }

    public boolean isEnabledForContext(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (variable == null) {
            return false;
        }
        DataType dataType = variable.getDataType();
        return this.hasCustomEditorForBaseDataType(dataType);
    }

    private boolean hasCustomEditorForBaseDataType(DataType dataType) {
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        return baseDataType != null && service.isEditable(baseDataType);
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        HighVariable variable = tokenAtCursor.getHighVariable();
        DataType dataType = variable.getDataType();
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        DataTypeManager dataTypeManager = decompilerActionContext.getProgram().getDataTypeManager();
        DataTypeManager baseDtDTM = baseDataType.getDataTypeManager();
        if (baseDtDTM != dataTypeManager) {
            baseDataType = baseDataType.clone(dataTypeManager);
        }
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        service.edit(baseDataType);
    }
}

