/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.actions.AbstractFindReferencesDataTypeAction;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.awt.Component;

public class FindReferencesToDataTypeAction
extends AbstractFindReferencesDataTypeAction {
    private final DecompilerController controller;

    public FindReferencesToDataTypeAction(String owner, PluginTool tool, DecompilerController controller) {
        super(tool, "Find References To", owner, DEFAULT_KEY_STROKE);
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Find Uses of "}));
    }

    public DataType getDataType(ActionContext context) {
        DataType dataType;
        HighVariable highVariable;
        Varnode varnode;
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken token = decompilerPanel.getSelectedToken();
        if (token == null) {
            token = decompilerPanel.getTokenAtCursor();
        }
        if ((varnode = DecompilerUtils.getVarnodeRef(token)) != null && (highVariable = varnode.getHigh()) != null) {
            DataType dataType2 = highVariable.getDataType();
            return dataType2;
        }
        if (token instanceof ClangTypeToken) {
            dataType = ((ClangTypeToken)token).getDataType();
            return dataType;
        }
        if (token instanceof ClangFieldToken) {
            dataType = ((ClangFieldToken)token).getDataType();
            return dataType;
        }
        return null;
    }

    protected String getDataTypeField() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFieldToken) {
            return tokenAtCursor.getText();
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        DataType dataType = this.getDataType(context);
        this.updateMenuName(dataType);
        return super.isEnabledForContext(context);
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        super.actionPerformed(context);
    }

    private void updateMenuName(DataType type) {
        if (type == null) {
            return;
        }
        String typeName = type.getName();
        String menuName = "Find Uses of " + typeName;
        String fieldName = this.getDataTypeField();
        if (fieldName != null) {
            menuName = menuName + "." + fieldName;
        }
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{menuName});
        this.setPopupMenuData(data);
    }
}

