/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.ASTGraphTask;
import ghidra.app.services.GraphService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;

public class GraphASTControlFlowAction
extends DockingAction {
    private final DecompilerController controller;
    private final PluginTool tool;
    private final Plugin plugin;

    public GraphASTControlFlowAction(String owner, Plugin plugin, DecompilerController controller) {
        super("Graph AST Control Flow", owner);
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.controller = controller;
        this.setMenuBarData(new MenuData(new String[]{"Graph AST Control Flow"}, "graph"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return this.controller.getFunction() != null;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        GraphService graphService = (GraphService)this.tool.getService(GraphService.class);
        if (graphService == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"AST Graph Failed", (Object)"GraphService not found: Please add a graph service provider to your tool");
            return;
        }
        ToolOptions options = this.tool.getOptions("Graph");
        boolean reuseGraph = options.getBoolean("Reuse Graph", false);
        int codeLimitPerBlock = options.getInt("Max Code Lines Displayed", 10);
        HighFunction highFunction = this.controller.getHighFunction();
        Address locationAddr = this.controller.getLocation().getAddress();
        ASTGraphTask task = new ASTGraphTask(graphService, !reuseGraph, codeLimitPerBlock, locationAddr, highFunction, 0);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }
}

