/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.actions;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import javax.swing.KeyStroke;

public abstract class AbstractSharedKeybindingAction
extends DockingAction
implements OptionsChangeListener {
    protected PluginTool tool;

    protected AbstractSharedKeybindingAction(PluginTool tool, String name, String owner, KeyStroke defaultkeyStroke) {
        super(name, owner, false);
        this.tool = tool;
        DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction(name, defaultkeyStroke);
        tool.addAction((DockingActionIf)action);
        ToolOptions options = tool.getOptions("Key Bindings");
        KeyStroke optionsKeyStroke = options.getKeyStroke(action.getFullName(), defaultkeyStroke);
        if (defaultkeyStroke != null) {
            if (!defaultkeyStroke.equals(optionsKeyStroke)) {
                this.setUnvalidatedKeyBindingData(new KeyBindingData(optionsKeyStroke));
            } else {
                this.setKeyBindingData(new KeyBindingData(optionsKeyStroke));
            }
        } else if (optionsKeyStroke != null) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(optionsKeyStroke));
        }
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        String actionName = this.getName();
        if (name.startsWith(actionName)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

