/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.data.CycleGroup;
import javax.swing.KeyStroke;

public class CycleGroupAction
extends CompositeEditorTableAction
implements OptionsChangeListener {
    private static final String GROUP_NAME = "3_CYCLE_DT_EDITOR_ACTION";
    private CycleGroup cycleGroup;

    public CycleGroupAction(CompositeEditorProvider provider, CycleGroup cycleGroup) {
        super(provider, cycleGroup.getName(), GROUP_NAME, new String[]{"Cycle", cycleGroup.getName()}, new String[]{"Cycle", cycleGroup.getName()}, null);
        this.cycleGroup = cycleGroup;
        DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction(cycleGroup.getName(), cycleGroup.getDefaultKeyStroke());
        this.tool.addAction((DockingActionIf)action);
        ToolOptions options = this.tool.getOptions("Key Bindings");
        KeyStroke defaultKeyStroke = cycleGroup.getDefaultKeyStroke();
        KeyStroke keyStroke = options.getKeyStroke(action.getFullName(), defaultKeyStroke);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        if (!defaultKeyStroke.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
        this.adjustEnablement();
    }

    public CycleGroup getCycleGroup() {
        return this.cycleGroup;
    }

    public void actionPerformed(ActionContext context) {
        this.model.cycleDataType(this.cycleGroup);
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(true);
    }

    @Override
    public String getHelpName() {
        return "Cycle";
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (name.startsWith(this.cycleGroup.getName())) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

