/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.data.CreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.data.CreateDataInStructureBackgroundCmd;
import ghidra.app.cmd.data.CreateDataInStructureCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import javax.swing.KeyStroke;

public class CycleGroupAction
extends DockingAction
implements OptionsChangeListener {
    private DataPlugin plugin;
    private CycleGroup cycleGroup;

    CycleGroupAction(CycleGroup group, DataPlugin plugin) {
        super(group.getName(), plugin.getName(), false);
        this.plugin = plugin;
        this.cycleGroup = group;
        PluginTool tool = plugin.getTool();
        DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction(this.cycleGroup.getName(), this.cycleGroup.getDefaultKeyStroke());
        tool.addAction((DockingActionIf)action);
        ToolOptions options = tool.getOptions("Key Bindings");
        KeyStroke defaultKeyStroke = this.cycleGroup.getDefaultKeyStroke();
        KeyStroke keyStroke = options.getKeyStroke(action.getFullName(), defaultKeyStroke);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.setPopupMenuData(new MenuData(new String[]{"Data", "Cycle", group.getName()}, null, null));
        if (!defaultKeyStroke.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
        this.setEnabled(true);
    }

    public void dispose() {
        this.cycleGroup = null;
        this.plugin = null;
        super.dispose();
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof ListingActionContext) {
            return this.plugin.isCreateDataAllowed((ListingActionContext)contextObject);
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject;
        if (context != null && (contextObject = context.getContextObject()) instanceof ListingActionContext) {
            ListingActionContext programContextObject = (ListingActionContext)contextObject;
            this.cycleData(programContextObject);
            return;
        }
    }

    private void cycleData(ListingActionContext context) {
        Listing listing = context.getProgram().getListing();
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        if (selection != null && !selection.isEmpty()) {
            BackgroundCommand cmd = null;
            DataType dt = null;
            Address addr = selection.getMinAddress();
            Data data = listing.getDataContaining(addr);
            InteriorSelection intSel = selection.getInteriorSelection();
            if (intSel == null) {
                dt = this.cycleGroup.getNextDataType(data.getDataType(), true);
                if (dt == null) {
                    return;
                }
                cmd = new CreateDataBackgroundCmd(selection, dt);
            } else {
                int[] fromPath = intSel.getFrom().getComponentPath();
                long selectionLength = selection.getNumAddresses();
                if (selectionLength > Integer.MAX_VALUE) {
                    Msg.showInfo((Object)((Object)this), null, (String)"Selection Too Big", (Object)"This operation does not support selection size > 0x7fffffff byte addresses.");
                    return;
                }
                int length = (int)selectionLength;
                Data compData = data.getComponent(fromPath);
                if (compData == null) {
                    return;
                }
                dt = this.cycleGroup.getNextDataType(compData.getDataType(), true);
                if (dt == null) {
                    return;
                }
                cmd = new CreateDataInStructureBackgroundCmd(addr, fromPath, length, dt);
            }
            if (selection.getNumAddresses() < 2048L) {
                this.plugin.getPluginTool().execute((Command)cmd, (DomainObject)context.getProgram());
            } else {
                this.plugin.getPluginTool().executeBackgroundCommand(cmd, (UndoableDomainObject)context.getProgram());
            }
            this.plugin.updateRecentlyUsed(dt);
        } else if (location != null) {
            Address addr = location.getAddress();
            Data data = listing.getDataContaining(addr);
            if (data == null) {
                return;
            }
            int[] compPath = location.getComponentPath();
            if (compPath == null || compPath.length <= 0) {
                DataType dt = this.cycleGroup.getNextDataType(data.getDataType(), true);
                if (dt != null) {
                    this.plugin.getPluginTool().execute((Command)new CreateDataCmd(addr, dt, true, false), (DomainObject)context.getProgram());
                    this.plugin.updateRecentlyUsed(dt);
                }
            } else {
                DataType dt;
                Data compData = data.getComponent(compPath);
                if (compData != null && (dt = this.cycleGroup.getNextDataType(compData.getDataType(), true)) != null) {
                    this.plugin.getPluginTool().execute((Command)new CreateDataInStructureCmd(addr, compPath, dt), (DomainObject)context.getProgram());
                    this.plugin.updateRecentlyUsed(dt);
                }
            }
        }
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (name.startsWith(this.cycleGroup.getName())) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

