/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.app.plugin.core.data.RenameDataFieldDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FieldNameFieldLocation;
import ghidra.program.util.ProgramLocation;
import javax.swing.KeyStroke;

class RenameDataFieldAction
extends DockingAction {
    private static final KeyStroke KEY_BINDING = KeyStroke.getKeyStroke(78, 0);
    private DataPlugin plugin;
    private RenameDataFieldDialog dialog;

    public RenameDataFieldAction(DataPlugin plugin) {
        super("Rename Data Field", plugin.getName());
        this.dialog = new RenameDataFieldDialog(plugin);
        this.setPopupMenuData(new MenuData(new String[]{"Data", "Rename Field"}, null, "BasicData"));
        this.setKeyBindingData(new KeyBindingData(78, 0));
        this.plugin = plugin;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionContext context) {
        ListingActionContext programActionContext = (ListingActionContext)context.getContextObject();
        PluginTool tool = this.plugin.getTool();
        Program program = programActionContext.getProgram();
        ProgramLocation loc = programActionContext.getLocation();
        Data data = program.getListing().getDataContaining(loc.getAddress());
        DataType type = data.getDataType();
        if (type instanceof Composite) {
            DataTypeComponent subComp;
            Composite comp = (Composite)type;
            int[] compPath = loc.getComponentPath();
            for (int i = 0; i < compPath.length - 1; ++i) {
                subComp = comp.getComponent(compPath[i]);
                type = subComp.getDataType();
                if (!(type instanceof Composite)) {
                    return;
                }
                comp = (Composite)type;
            }
            Data instance = data.getComponent(compPath);
            subComp = comp.getComponent(compPath[compPath.length - 1]);
            this.dialog.setDataComponent(program, subComp, instance.getFieldName());
            tool.showDialog((DialogComponentProvider)this.dialog, tool.getComponentProvider("CodeBrowserPlugin"));
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof ListingActionContext)) {
            return false;
        }
        ListingActionContext programActionContext = (ListingActionContext)contextObject;
        return programActionContext.getLocation() instanceof FieldNameFieldLocation;
    }
}

