/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BackgroundIcon;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class FileArchiveNode
extends ArchiveNode {
    private static ImageIcon CHECKED_OUT_EXCLUSIVE_ICON = ResourceManager.loadImage((String)"images/checkex.png");
    FileArchive fileArchive;

    public FileArchiveNode(FileArchive archive) {
        super(archive);
        this.fileArchive = archive;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        BackgroundIcon bgIcon = new BackgroundIcon(24, 16, false);
        MultiIcon multiIcon = new MultiIcon((Icon)bgIcon);
        boolean hasWriteLock = this.fileArchive.hasWriteLock();
        ImageIcon baseIcon = this.fileArchive.getIcon(expanded);
        multiIcon.addIcon((Icon)baseIcon);
        if (hasWriteLock) {
            multiIcon.addIcon((Icon)new TranslateIcon((Icon)CHECKED_OUT_EXCLUSIVE_ICON, 8, -4));
        }
        return multiIcon;
    }

    @Override
    public String getToolTip() {
        ResourceFile file = this.fileArchive.getFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "[Unsaved New Archive]";
    }

    public boolean hasWriteLock() {
        return this.fileArchive.hasWriteLock();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (super.equals(o)) {
            ResourceFile myFile = this.fileArchive.getFile();
            ResourceFile otherFile = ((FileArchiveNode)o).fileArchive.getFile();
            return myFile.equals((Object)otherFile);
        }
        return false;
    }
}

