/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.equate.EquateTableProvider;
import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.util.UniversalID;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

class EquateRenderer
extends GhidraTableCellRenderer {
    private EquateTableProvider equateProvider;

    EquateRenderer(EquateTableProvider equateProvider) {
        this.equateProvider = equateProvider;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        int column = data.getColumnViewIndex();
        boolean isSelected = data.isSelected();
        label.setText(" ");
        Equate eq = (Equate)value;
        if (eq == null) {
            return label;
        }
        String columnName = table.getColumnName(column);
        if (columnName.equals("Name")) {
            if (!eq.isValidUUID()) {
                label.setForeground(isSelected ? Color.WHITE : Color.RED);
            } else if (!eq.isEnumBased()) {
                label.setForeground(isSelected ? Color.WHITE : Color.BLUE.brighter());
            }
            label.setText(eq.getDisplayName());
            String tooltip = this.getEquateToolTip(eq);
            label.setToolTipText(tooltip);
        } else if (columnName.equals("Value")) {
            label.setText(eq.getDisplayValue());
        } else if (columnName.equals("# Refs")) {
            int referenceCount = eq.getReferenceCount();
            String text = Integer.toString(referenceCount);
            label.setText(text);
        }
        return label;
    }

    private String getEquateToolTip(Equate eq) {
        Program program = this.equateProvider.getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        UniversalID id = eq.getEnumUUID();
        if (id == null) {
            return eq.getName();
        }
        Enum enoom = (Enum)dtm.findDataTypeForID(id);
        if (enoom == null) {
            return null;
        }
        String tooltip = ToolTipUtils.getToolTipText((DataType)enoom);
        return tooltip;
    }
}

