/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.program.model.listing.FunctionTag;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FunctionTagList
extends JList<FunctionTag> {
    public FunctionTagList(DefaultListModel<FunctionTag> model) {
        super(model);
        this.setCellRenderer(this.getCellRenderer());
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int index = this.locationToIndex(evt.getPoint());
        if (index == -1 || index >= this.getModel().getSize()) {
            return "";
        }
        Object obj = this.getModel().getElementAt(index);
        if (obj instanceof FunctionTag) {
            FunctionTag tag = (FunctionTag)obj;
            if (tag.getComment().isEmpty()) {
                return "<no comment set>";
            }
            return tag.getComment();
        }
        return "";
    }

    @Override
    public ListCellRenderer<? super FunctionTag> getCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                FunctionTag tag = (FunctionTag)value;
                Component listCellRendererComponent = super.getListCellRendererComponent(list, tag.getName(), index, isSelected, cellHasFocus);
                if (value instanceof FunctionTagTemp) {
                    if (cellHasFocus) {
                        listCellRendererComponent.setForeground(Color.white);
                    } else {
                        listCellRendererComponent.setForeground(Color.blue);
                    }
                }
                return listCellRendererComponent;
            }
        };
    }
}

