/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.searchtext.SearchOptions;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.CommentFieldSearcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.DataMnemonicOperandFieldSearcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.FunctionFieldSearcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.InstructionMnemonicOperandFieldSearcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.LabelFieldSearcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UserSearchUtils;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class ProgramDatabaseSearcher
implements Searcher {
    private List<ProgramDatabaseFieldSearcher> searchers = new ArrayList<ProgramDatabaseFieldSearcher>();
    private Address currentAddress;
    private boolean isForward;
    private SearchOptions searchOptions;
    private TaskMonitor monitor;

    public ProgramDatabaseSearcher(ServiceProvider serviceProvider, Program program, ProgramLocation startLoc, AddressSetView set, SearchOptions options, TaskMonitor monitor) {
        this.searchOptions = options;
        this.monitor = monitor != null ? monitor : TaskMonitorAdapter.DUMMY_MONITOR;
        this.isForward = options.isForward();
        if (startLoc == null && set == null) {
            startLoc = new ProgramLocation(program, this.isForward ? program.getMinAddress() : program.getMaxAddress());
        }
        this.initialize(serviceProvider, program, startLoc, set, options);
        this.currentAddress = this.findNextSignificantAddress();
        this.monitor.setIndeterminate(true);
    }

    @Override
    public ProgramLocation search() {
        List<ProgramDatabaseFieldSearcher> orderedSearchers = this.searchers;
        if (!this.searchOptions.isForward()) {
            orderedSearchers = new ArrayList<ProgramDatabaseFieldSearcher>(this.searchers);
            Collections.reverse(orderedSearchers);
        }
        while (this.currentAddress != null) {
            this.monitor.setMessage("Checking address " + this.currentAddress);
            for (ProgramDatabaseFieldSearcher searcher : orderedSearchers) {
                if (!searcher.hasMatch(this.currentAddress)) continue;
                return searcher.getMatch();
            }
            this.currentAddress = this.findNextSignificantAddress();
        }
        return null;
    }

    @Override
    public SearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    @Override
    public void setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    private Address findNextSignificantAddress() {
        Address nextAddress = null;
        for (ProgramDatabaseFieldSearcher searcher : this.searchers) {
            if (this.monitor.isCancelled()) {
                return null;
            }
            Address nextAddressToCheck = searcher.getNextSignificantAddress(this.currentAddress);
            nextAddress = this.isForward ? this.getMin(nextAddress, nextAddressToCheck) : this.getMax(nextAddress, nextAddressToCheck);
        }
        return nextAddress;
    }

    private Address getMin(Address address1, Address address2) {
        if (address1 == null) {
            return address2;
        }
        if (address2 == null) {
            return address1;
        }
        return address1.compareTo((Object)address2) < 0 ? address1 : address2;
    }

    private Address getMax(Address address1, Address address2) {
        if (address1 == null) {
            return address2;
        }
        if (address2 == null) {
            return address1;
        }
        return address1.compareTo((Object)address2) > 0 ? address1 : address2;
    }

    private void initialize(ServiceProvider serviceProvider, Program program, ProgramLocation start, AddressSetView view, SearchOptions options) {
        this.searchOptions = options;
        boolean forward = options.isForward();
        AddressSetView trimmedSet = this.adjustSearchSet(program, start, view, forward);
        ProgramLocation adjustedStart = this.adjustStartLocation(program, start, trimmedSet, forward);
        Pattern pattern = UserSearchUtils.createSearchPattern((String)options.getText(), (boolean)options.isCaseSensitive());
        BrowserCodeUnitFormat format = new BrowserCodeUnitFormat(serviceProvider, false);
        if (options.searchComments()) {
            this.searchers.add(new CommentFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, 3));
        }
        if (options.searchFunctions()) {
            this.searchers.add(new FunctionFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern));
        }
        if (options.searchComments()) {
            this.searchers.add(new CommentFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, 1));
        }
        if (options.searchLabels()) {
            this.searchers.add(new LabelFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern));
        }
        if (options.searchBothDataMnemonicsAndOperands()) {
            this.searchers.add(DataMnemonicOperandFieldSearcher.createDataMnemonicAndOperandFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchOnlyDataMnemonics()) {
            this.searchers.add(DataMnemonicOperandFieldSearcher.createDataMnemonicOnlyFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchOnlyDataOperands()) {
            this.searchers.add(DataMnemonicOperandFieldSearcher.createDataOperandOnlyFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchBothInstructionMnemonicAndOperands()) {
            this.searchers.add(InstructionMnemonicOperandFieldSearcher.createInstructionMnemonicAndOperandFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchOnlyInstructionMnemonics()) {
            this.searchers.add(InstructionMnemonicOperandFieldSearcher.createInstructionMnemonicOnlyFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchOnlyInstructionOperands()) {
            this.searchers.add(InstructionMnemonicOperandFieldSearcher.createInstructionOperandOnlyFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, format));
        }
        if (options.searchComments()) {
            this.searchers.add(new CommentFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, 0));
            this.searchers.add(new CommentFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, 4));
            this.searchers.add(new CommentFieldSearcher(program, adjustedStart, trimmedSet, forward, pattern, 2));
        }
    }

    private AddressSetView adjustSearchSet(Program program, ProgramLocation start, AddressSetView view, boolean forward) {
        AddressSetView trimmedSet = view;
        ProgramLocation adjustedStart = start;
        if (adjustedStart != null && trimmedSet != null && !(trimmedSet = this.trimAddressSet(program, trimmedSet, adjustedStart.getAddress(), forward)).isEmpty()) {
            Address maxAddress = trimmedSet.getMaxAddress();
            if (!forward && adjustedStart.getAddress().compareTo((Object)maxAddress) > 0 && !(adjustedStart = new ProgramLocation(program, maxAddress)).getAddress().equals((Object)maxAddress)) {
                trimmedSet = this.trimAddressSet(program, trimmedSet, adjustedStart.getAddress(), forward);
            }
        }
        return trimmedSet;
    }

    private ProgramLocation adjustStartLocation(Program program, ProgramLocation start, AddressSetView trimmedSet, boolean forward) {
        ProgramLocation adjustedStart = start;
        if (adjustedStart != null && trimmedSet != null && !trimmedSet.isEmpty()) {
            Address minAddress = trimmedSet.getMinAddress();
            Address maxAddress = trimmedSet.getMaxAddress();
            if (forward && adjustedStart.getAddress().compareTo((Object)minAddress) < 0) {
                return new ProgramLocation(program, minAddress);
            }
            if (!forward && adjustedStart.getAddress().compareTo((Object)maxAddress) > 0) {
                return new ProgramLocation(program, maxAddress);
            }
        }
        return adjustedStart;
    }

    private AddressSetView trimAddressSet(Program program, AddressSetView view, Address address, boolean searchForward) {
        if (view == null || view.isEmpty()) {
            return view;
        }
        if (searchForward) {
            Address maxAddress = view.getMaxAddress();
            if (address.compareTo((Object)maxAddress) > 0) {
                return new AddressSet();
            }
            return view.intersect((AddressSetView)program.getAddressFactory().getAddressSet(address, maxAddress));
        }
        Address minAddress = view.getMinAddress();
        if (address.compareTo((Object)minAddress) < 0) {
            return new AddressSet();
        }
        return view.intersect((AddressSetView)program.getAddressFactory().getAddressSet(minAddress, address));
    }
}

