/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.propertymanager;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.debug.propertymanager.PropertyDeleteCmd;
import ghidra.app.plugin.debug.propertymanager.PropertyManagerPlugin;
import ghidra.app.plugin.debug.propertymanager.PropertyManagerTableModel;
import ghidra.app.services.MarkerSet;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import resources.ResourceManager;

public class PropertyManagerProvider
extends ComponentProviderAdapter {
    protected static final ImageIcon ICON = ResourceManager.loadImage((String)"images/document-properties.png");
    protected static final String DELETE_PROPERTIES_ACTION_NAME = "Delete Properties";
    private PropertyManagerPlugin plugin;
    private Program currentProgram;
    private AddressSetView restrictedView;
    private JTable table;
    private PropertyManagerTableModel model;
    private JPanel workPanel;
    private DockingAction deleteAction;
    private ListSelectionListener selectionListener;
    private TableModelListener tableModelListener;

    public PropertyManagerProvider(PropertyManagerPlugin plugin) {
        super(plugin.getTool(), "Manage Properties", plugin.getName());
        this.plugin = plugin;
        this.setIcon(ICON);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "PropertyViewerPlugin"));
        this.setTitle("Manage Properties");
        this.addToTool();
        this.deleteAction = new DockingAction(DELETE_PROPERTIES_ACTION_NAME, plugin.getName()){

            public void actionPerformed(ActionContext context) {
                int row = PropertyManagerProvider.this.table.getSelectedRow();
                if (row >= 0) {
                    String propName = (String)PropertyManagerProvider.this.model.getValueAt(row, 0);
                    PropertyManagerProvider.this.model.removeRow(row);
                    PropertyDeleteCmd cmd = new PropertyDeleteCmd(propName, PropertyManagerProvider.this.restrictedView);
                    PropertyManagerProvider.this.plugin.getTool().execute((Command)cmd, (DomainObject)PropertyManagerProvider.this.currentProgram);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                return context.getContextObject() != null;
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}));
        this.deleteAction.setHelpLocation(new HelpLocation(plugin.getName(), "DeleteProperties"));
        this.deleteAction.setEnabled(true);
        plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
    }

    void dispose() {
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        this.tool.removeComponentProvider((ComponentProvider)this);
    }

    void refresh() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.removeListSelectionListener(this.selectionListener);
        this.model.removeTableModelListener(this.tableModelListener);
        this.currentProgram = this.plugin.getCurrentProgram();
        this.restrictedView = this.plugin.getCurrentSelection();
        String propName = null;
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            propName = (String)this.model.getValueAt(row, 0);
            this.table.clearSelection();
        }
        this.model.update(this.currentProgram, this.restrictedView);
        if (propName != null) {
            int rows = this.model.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!propName.equals(this.model.getValueAt(i, 0))) continue;
                this.table.getSelectionModel().setSelectionInterval(i, i);
                break;
            }
        }
        this.model.addTableModelListener(this.tableModelListener);
        selectionModel.addListSelectionListener(this.selectionListener);
    }

    private JPanel createWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.model = new PropertyManagerTableModel();
        this.tableModelListener = e -> this.refreshMarkers();
        this.model.addTableModelListener(this.tableModelListener);
        this.table = new GhidraTable(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel tlsm = this.table.getSelectionModel();
        this.selectionListener = e -> {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            this.refreshMarkers(this.table.getSelectedRow());
        };
        tlsm.addListSelectionListener(this.selectionListener);
        JScrollPane tablePane = new JScrollPane(this.table, 20, 30);
        tablePane.setPreferredSize(new Dimension(200, 100));
        panel.add((Component)tablePane, "Center");
        return panel;
    }

    private void refreshMarkers() {
        this.refreshMarkers(this.table.getSelectedRow());
    }

    private void refreshMarkers(int row) {
        MarkerSet searchMarks = this.plugin.getSearchMarks();
        if (searchMarks == null) {
            return;
        }
        searchMarks.clearAll();
        if (row < 0) {
            return;
        }
        String propName = (String)this.model.getValueAt(row, 0);
        if (propName == null) {
            return;
        }
        Listing listing = this.currentProgram.getListing();
        CodeUnitIterator cui = this.restrictedView == null || this.restrictedView.isEmpty() ? listing.getCodeUnitIterator(propName, true) : listing.getCodeUnitIterator(propName, this.restrictedView, true);
        while (cui.hasNext()) {
            CodeUnit cu = cui.next();
            searchMarks.add(cu.getMinAddress());
        }
    }

    public void componentHidden() {
        this.table.clearSelection();
        this.plugin.disposeSearchMarks();
    }

    public void componentShown() {
        if (this.table != null) {
            this.refresh();
        }
    }

    public JComponent getComponent() {
        if (this.workPanel == null) {
            this.workPanel = this.createWorkPanel();
            this.refresh();
        }
        return this.workPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        Rectangle rowBounds;
        int row;
        if (event != null && event.getSource() == this.table && (row = this.table.getSelectedRow()) >= 0 && (rowBounds = this.table.getCellRect(row, 0, true)).contains(event.getPoint())) {
            return new ActionContext((ComponentProvider)this, (Object)rowBounds);
        }
        return null;
    }

    void programDeactivated() {
        this.currentProgram = null;
        if (this.model != null) {
            this.model.update(null, null);
        }
    }

    void programActivated(Program program) {
        this.currentProgram = program;
        if (this.model != null) {
            this.model.update(program, null);
        }
    }

    public void componentActivated() {
        this.refresh();
    }
}

