/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.UnsignedLeb128DataType;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;

public class LSDACallSiteRecord
extends GccAnalysisClass {
    private RegionDescriptor region;
    private Address nextAddress;
    private long callSitePosition;
    private long callSiteLength;
    private long landingPadOffset;
    private int actionOffset;
    private AddressRange callSiteRange;
    private Address landingPadAddr;

    public LSDACallSiteRecord(TaskMonitor monitor, Program program, RegionDescriptor region) {
        super(monitor, program);
        this.region = region;
    }

    public void create(Address addr, DwarfEHDecoder decoder) throws MemoryAccessException {
        if (addr == null || this.monitor.isCancelled()) {
            return;
        }
        Address baseAddr = addr;
        this.monitor.setMessage("Creating LSDA Call Site Record");
        Address callSiteDataAddr = addr;
        addr = this.createCallSitePosition(addr, decoder);
        Address lpDataAddr = addr = this.createCallSiteLength(addr, decoder);
        addr = this.createLandingPad(addr, decoder);
        addr = this.createAction(addr);
        Address lpStart = this.region.getLSDATable().getHeader().getLPStartAddress();
        Address callSiteBaseAddr = lpStart.add(this.getCallSitePosition());
        Address callSiteExtentAddr = callSiteBaseAddr.add(this.getCallSiteLength() - 1L);
        this.callSiteRange = new AddressRangeImpl(callSiteBaseAddr, callSiteExtentAddr);
        this.landingPadAddr = lpStart.add(this.getLandingPadOffset());
        SetCommentCmd commentCmd = new SetCommentCmd(baseAddr, 3, "(LSDA) Call Site Record");
        commentCmd.applyTo((DomainObject)this.program);
        if (this.program.getMemory().contains(callSiteBaseAddr)) {
            this.program.getReferenceManager().addMemoryReference(callSiteDataAddr, callSiteBaseAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        }
        if (this.program.getMemory().contains(this.landingPadAddr)) {
            this.program.getReferenceManager().addMemoryReference(lpDataAddr, this.landingPadAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        }
        this.nextAddress = addr;
    }

    private Address createCallSitePosition(Address addr, DwarfEHDecoder decoder) throws MemoryAccessException {
        String comment = "(LSDA Call Site) IP Offset";
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr);
        this.callSitePosition = decoder.decode(ctx);
        int encodedLen = ctx.getEncodedLength();
        DataType encodedDt = decoder.getDataType(this.program);
        LSDACallSiteRecord.createAndCommentData(this.program, addr, encodedDt, comment, 0);
        return addr.add((long)encodedLen);
    }

    private Address createCallSiteLength(Address addr, DwarfEHDecoder decoder) throws MemoryAccessException {
        String comment = "(LSDA Call Site) IP Range Length";
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr);
        this.callSiteLength = decoder.decode(ctx);
        int encodedLen = ctx.getEncodedLength();
        DataType encodedDt = decoder.getDataType(this.program);
        LSDACallSiteRecord.createAndCommentData(this.program, addr, encodedDt, comment, 0);
        return addr.add((long)encodedLen);
    }

    private Address createLandingPad(Address addr, DwarfEHDecoder decoder) throws MemoryAccessException {
        String comment = "(LSDA Call Site) Landing Pad Address";
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr);
        this.landingPadOffset = decoder.decode(ctx);
        int encodedLen = ctx.getEncodedLength();
        DataType encodedDt = decoder.getDataType(this.program);
        LSDACallSiteRecord.createAndCommentData(this.program, addr, encodedDt, comment, 0);
        return addr.add((long)encodedLen);
    }

    private Address createAction(Address addr) {
        Object comment = "(LSDA Call Site) Action Table Offset";
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        int encodedLen = uleb.getLength((MemBuffer)buf, -1);
        Object actionObj = uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), encodedLen);
        this.actionOffset = (int)((Scalar)actionObj).getUnsignedValue();
        encodedLen = ((Scalar)actionObj).bitLength() / 8;
        if (this.actionOffset == 0) {
            comment = (String)comment + " (No action -- cleanup)";
        }
        LSDACallSiteRecord.createAndCommentData(this.program, addr, (DataType)uleb, (String)comment, 0);
        return addr.add((long)encodedLen);
    }

    Address getNextAddress() {
        return this.nextAddress;
    }

    private long getCallSitePosition() {
        return this.callSitePosition;
    }

    public AddressRange getCallSite() {
        return this.callSiteRange;
    }

    private long getCallSiteLength() {
        return this.callSiteLength;
    }

    public Address getLandingPad() {
        return this.landingPadAddr;
    }

    public long getLandingPadOffset() {
        return this.landingPadOffset;
    }

    public int getActionOffset() {
        return this.actionOffset;
    }
}

