/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.match;

import generic.hash.FNV1a64MessageDigest;
import generic.hash.MessageDigest;
import ghidra.app.plugin.prototype.match.AbstractFunctionHasher;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class ExactBytesFunctionHasher
extends AbstractFunctionHasher {
    public static final ExactBytesFunctionHasher INSTANCE = new ExactBytesFunctionHasher();
    private MessageDigest digest = new FNV1a64MessageDigest();

    private ExactBytesFunctionHasher() {
    }

    @Override
    public int commonBitCount(Function funcA, Function funcB, TaskMonitor monitor) {
        return (int)funcA.getBody().getNumAddresses() * 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long hash(TaskMonitor monitor, ArrayList<CodeUnit> units, int byteCount) throws MemoryAccessException, CancelledException {
        byte[] buffer = new byte[byteCount];
        int offset = 0;
        for (CodeUnit codeUnit : units) {
            if (monitor.isCancelled()) {
                return 0L;
            }
            try {
                codeUnit.getBytesInCodeUnit(buffer, offset);
            }
            catch (MemoryAccessException e) {
                Msg.warn((Object)this, (Object)("Could not get code unit bvtes at " + codeUnit.getAddress()));
            }
            offset += codeUnit.getLength();
        }
        if (offset != byteCount) {
            throw new IllegalStateException("did NOT use all the codeUnit buffer bytes");
        }
        MessageDigest messageDigest = this.digest;
        synchronized (messageDigest) {
            this.digest.reset();
            this.digest.update(buffer, monitor);
            return this.digest.digestLong();
        }
    }
}

