/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.Writeable;
import ghidra.app.util.bin.format.elf.ElfDynamic;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfStringTable;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.extend.ElfExtensionFactory;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ElfHeader
implements StructConverter,
Writeable {
    private static final int MAX_HEADERS_TO_CHECK_FOR_IMAGEBASE = 20;
    private HashMap<Integer, ElfProgramHeaderType> programHeaderTypeMap;
    private HashMap<Integer, ElfSectionHeaderType> sectionHeaderTypeMap;
    private HashMap<Integer, ElfDynamicType> dynamicTypeMap;
    private FactoryBundledWithBinaryReader reader;
    private ElfLoadAdapter elfLoadAdapter = new ElfLoadAdapter();
    private byte e_ident_magic_num;
    private String e_ident_magic_str;
    private byte e_ident_class;
    private byte e_ident_data;
    private byte e_ident_version;
    private byte[] e_ident_pad;
    private short e_type;
    private short e_machine;
    private int e_version;
    private long e_entry;
    private long e_phoff;
    private long e_shoff;
    private int e_flags;
    private short e_ehsize;
    private short e_phentsize;
    private short e_phnum;
    private short e_shentsize;
    private short e_shnum;
    private short e_shstrndx;
    private Structure headerStructure;
    private boolean parsed = false;
    private boolean parsedSectionHeaders = false;
    private ElfSectionHeader[] sectionHeaders = new ElfSectionHeader[0];
    private ElfProgramHeader[] programHeaders = new ElfProgramHeader[0];
    private ElfStringTable[] stringTables = new ElfStringTable[0];
    private ElfSymbolTable[] symbolTables = new ElfSymbolTable[0];
    private ElfRelocationTable[] relocationTables = new ElfRelocationTable[0];
    private ElfDynamicTable dynamicTable;
    private ElfStringTable dynamicStringTable;
    private ElfSymbolTable dynamicSymbolTable;
    private String[] dynamicLibraryNames;
    private boolean hasLittleEndianHeaders;
    private static int INITIAL_READ_LEN = 34;
    private Long elfImageBase;
    private Long preLinkImageBase = null;

    public static ElfHeader createElfHeader(GenericFactory factory, ByteProvider provider) throws ElfException {
        ElfHeader elfHeader = (ElfHeader)factory.create(ElfHeader.class, new Object[0]);
        elfHeader.initElfHeader(factory, provider);
        return elfHeader;
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    protected void initElfHeader(GenericFactory factory, ByteProvider provider) throws ElfException {
        try {
            boolean magicMatch;
            this.determineHeaderEndianess(provider);
            this.reader = new FactoryBundledWithBinaryReader(factory, provider, this.hasLittleEndianHeaders);
            this.e_ident_magic_num = this.reader.readNextByte();
            this.e_ident_magic_str = this.reader.readNextAsciiString(3);
            boolean bl = magicMatch = 127 == this.e_ident_magic_num && "ELF".equalsIgnoreCase(this.e_ident_magic_str);
            if (!magicMatch) {
                throw new ElfException("Not a valid ELF executable.");
            }
            this.e_ident_class = this.reader.readNextByte();
            this.e_ident_data = this.reader.readNextByte();
            this.e_ident_version = this.reader.readNextByte();
            this.e_ident_pad = this.reader.readNextByteArray(9);
            this.e_type = this.reader.readNextShort();
            this.e_machine = this.reader.readNextShort();
            this.e_version = this.reader.readNextInt();
            if (this.is32Bit()) {
                this.e_entry = (long)this.reader.readNextInt() & 0xFFFFFFFFL;
                this.e_phoff = (long)this.reader.readNextInt() & 0xFFFFFFFFL;
                this.e_shoff = (long)this.reader.readNextInt() & 0xFFFFFFFFL;
            } else if (this.is64Bit()) {
                this.e_entry = this.reader.readNextLong();
                this.e_phoff = this.reader.readNextLong();
                this.e_shoff = this.reader.readNextLong();
            } else {
                throw new ElfException("Only 32-bit and 64-bit ELF headers are supported.");
            }
            this.e_flags = this.reader.readNextInt();
            this.e_ehsize = this.reader.readNextShort();
            this.e_phentsize = this.reader.readNextShort();
            this.e_phnum = this.reader.readNextShort();
            this.e_shentsize = this.reader.readNextShort();
            this.e_shnum = this.reader.readNextShort();
            this.e_shstrndx = this.reader.readNextShort();
        }
        catch (IOException e) {
            throw new ElfException(e);
        }
    }

    private void initElfLoadAdapter() {
        this.programHeaderTypeMap = new HashMap();
        ElfProgramHeaderType.addDefaultTypes(this.programHeaderTypeMap);
        this.sectionHeaderTypeMap = new HashMap();
        ElfSectionHeaderType.addDefaultTypes(this.sectionHeaderTypeMap);
        this.dynamicTypeMap = new HashMap();
        ElfDynamicType.addDefaultTypes(this.dynamicTypeMap);
        ElfLoadAdapter extensionAdapter = ElfExtensionFactory.getLoadAdapter(this);
        if (extensionAdapter != null) {
            extensionAdapter.addProgramHeaderTypes(this.programHeaderTypeMap);
            extensionAdapter.addSectionHeaderTypes(this.sectionHeaderTypeMap);
            extensionAdapter.addDynamicTypes(this.dynamicTypeMap);
            this.elfLoadAdapter = extensionAdapter;
        }
    }

    public void parse() throws IOException {
        if (this.reader == null) {
            throw new IOException("ELF binary reader is null!");
        }
        if (this.parsed) {
            return;
        }
        this.initElfLoadAdapter();
        this.parsed = true;
        this.parseProgramHeaders();
        this.parseSectionHeaders();
        this.parseDynamicTable();
        this.parseStringTables();
        this.parseDynamicLibraryNames();
        this.parseSymbolTables();
        this.parseRelocationTables();
        this.parseGNU_d();
        this.parseGNU_r();
    }

    public ElfLoadAdapter getLoadAdapter() {
        return this.elfLoadAdapter;
    }

    public long adjustAddressForPrelink(long address) {
        long base = this.getPreLinkImageBase();
        if (base == -1L) {
            base = 0L;
        }
        return base + address;
    }

    public long unadjustAddressForPrelink(long address) {
        long base = this.getPreLinkImageBase();
        if (base == -1L) {
            base = 0L;
        }
        return address - base;
    }

    protected HashMap<Integer, ElfProgramHeaderType> getProgramHeaderTypeMap() {
        return this.programHeaderTypeMap;
    }

    protected HashMap<Integer, ElfSectionHeaderType> getSectionHeaderTypeMap() {
        return this.sectionHeaderTypeMap;
    }

    public ElfProgramHeaderType getProgramHeaderType(int type) {
        if (this.programHeaderTypeMap != null) {
            return this.programHeaderTypeMap.get(type);
        }
        return null;
    }

    public ElfSectionHeaderType getSectionHeaderType(int type) {
        if (this.sectionHeaderTypeMap != null) {
            return this.sectionHeaderTypeMap.get(type);
        }
        return null;
    }

    protected HashMap<Integer, ElfDynamicType> getDynamicTypeMap() {
        return this.dynamicTypeMap;
    }

    public ElfDynamicType getDynamicType(int type) {
        if (this.dynamicTypeMap != null) {
            return this.dynamicTypeMap.get(type);
        }
        return null;
    }

    String getTypeSuffix() {
        if (this.elfLoadAdapter == null) {
            return null;
        }
        String typeSuffix = this.elfLoadAdapter.getDataTypeSuffix();
        if (typeSuffix != null && typeSuffix.length() == 0) {
            typeSuffix = null;
        }
        return typeSuffix;
    }

    private void parseGNU_d() {
        ElfSectionHeader[] sections = this.getSections(0x6FFFFFFD);
        if (sections.length == 0) {
            return;
        }
    }

    private void parseGNU_r() {
        ElfSectionHeader[] sections = this.getSections(0x6FFFFFFE);
        if (sections.length == 0) {
            return;
        }
    }

    private void parseRelocationTables() throws IOException {
        ArrayList<ElfRelocationTable> relocationTableList = new ArrayList<ElfRelocationTable>();
        this.parseDynamicRelocTable(relocationTableList, ElfDynamicType.DT_REL, ElfDynamicType.DT_RELENT, ElfDynamicType.DT_RELSZ, false);
        this.parseDynamicRelocTable(relocationTableList, ElfDynamicType.DT_RELA, ElfDynamicType.DT_RELAENT, ElfDynamicType.DT_RELASZ, true);
        this.parseJMPRelocTable(relocationTableList);
        for (ElfSectionHeader section : this.sectionHeaders) {
            this.parseSectionBasedRelocationTable(section, relocationTableList);
        }
        this.relocationTables = new ElfRelocationTable[relocationTableList.size()];
        relocationTableList.toArray(this.relocationTables);
    }

    private void parseSectionBasedRelocationTable(ElfSectionHeader section, ArrayList<ElfRelocationTable> relocationTableList) throws IOException {
        try {
            int sectionHeaderType = section.getType();
            if (sectionHeaderType == 9 || sectionHeaderType == 4) {
                for (ElfRelocationTable relocTable : relocationTableList) {
                    if (relocTable.getFileOffset() != section.getOffset()) continue;
                    return;
                }
                int link = section.getLink();
                int info = section.getInfo();
                ElfSectionHeader sectionToBeRelocated = info != 0 ? this.getLinkedSection(info, new int[0]) : null;
                String relocaBaseName = sectionToBeRelocated != null ? sectionToBeRelocated.getNameAsString() : "PT_LOAD";
                ElfSectionHeader symbolTableSection = this.getLinkedSection(link, 11, 2);
                ElfSymbolTable symbolTable = this.getSymbolTable(symbolTableSection);
                boolean addendTypeReloc = sectionHeaderType == 4;
                Msg.debug((Object)this, (Object)("Elf relocation table section " + section.getNameAsString() + " linked to symbol table section " + symbolTableSection.getNameAsString() + " affecting " + relocaBaseName));
                relocationTableList.add(ElfRelocationTable.createElfRelocationTable(this.reader, this, section, section.getOffset(), section.getAddress(), section.getSize(), section.getEntrySize(), addendTypeReloc, symbolTable, sectionToBeRelocated));
            }
        }
        catch (NotFoundException e) {
            Msg.error((Object)this, (Object)("Failed to process relocation section " + section.getNameAsString() + ": " + e.getMessage()));
        }
    }

    private void parseJMPRelocTable(ArrayList<ElfRelocationTable> relocationTableList) throws IOException {
        boolean addendTypeReloc;
        if (this.dynamicTable == null) {
            return;
        }
        try {
            long tableType = this.dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTREL);
            addendTypeReloc = tableType == (long)ElfDynamicType.DT_RELA.value;
        }
        catch (NotFoundException e) {
            return;
        }
        this.parseDynamicRelocTable(relocationTableList, ElfDynamicType.DT_JMPREL, addendTypeReloc ? ElfDynamicType.DT_RELAENT : ElfDynamicType.DT_RELENT, ElfDynamicType.DT_PLTRELSZ, addendTypeReloc);
    }

    private void parseDynamicRelocTable(ArrayList<ElfRelocationTable> relocationTableList, ElfDynamicType relocTableAddrType, ElfDynamicType relocEntrySizeType, ElfDynamicType relocTableSizeType, boolean addendTypeReloc) throws IOException {
        if (this.dynamicTable == null) {
            return;
        }
        try {
            long relocTableAddr = this.adjustAddressForPrelink(this.dynamicTable.getDynamicValue(relocTableAddrType));
            ElfSectionHeader relocTableSectionHeader = this.getSectionLoadHeaderContaining(relocTableAddr);
            if (relocTableSectionHeader != null) {
                this.parseSectionBasedRelocationTable(relocTableSectionHeader, relocationTableList);
                return;
            }
            ElfProgramHeader relocTableLoadHeader = this.getProgramLoadHeaderContaining(relocTableAddr);
            if (relocTableLoadHeader == null) {
                Msg.warn((Object)this, (Object)("Failed to locate " + relocTableAddrType.name + " in memory at 0x" + Long.toHexString(relocTableAddr)));
                return;
            }
            if (this.dynamicSymbolTable == null) {
                Msg.warn((Object)this, (Object)("Failed to process " + relocTableAddrType.name + ", missing dynamic symbol table"));
                return;
            }
            long relocTableOffset = relocTableLoadHeader.getOffset(relocTableAddr);
            long tableEntrySize = this.dynamicTable.getDynamicValue(relocEntrySizeType);
            long tableSize = this.dynamicTable.getDynamicValue(relocTableSizeType);
            relocationTableList.add(ElfRelocationTable.createElfRelocationTable(this.reader, this, null, relocTableOffset, relocTableAddr, tableSize, tableEntrySize, addendTypeReloc, this.dynamicSymbolTable, null));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private ElfSectionHeader getLinkedSection(int sectionIndex, int ... expectedTypes) throws NotFoundException {
        if (sectionIndex < 0 || sectionIndex >= this.sectionHeaders.length) {
            throw new NotFoundException("invalid linked section index " + sectionIndex);
        }
        ElfSectionHeader section = this.sectionHeaders[sectionIndex];
        if (expectedTypes.length == 0) {
            return section;
        }
        for (int type : expectedTypes) {
            if (type != section.getType()) continue;
            return section;
        }
        throw new NotFoundException("unexpected section type for section index " + sectionIndex);
    }

    private void parseDynamicLibraryNames() {
        if (this.dynamicTable == null) {
            this.dynamicLibraryNames = new String[0];
            return;
        }
        ElfDynamic[] needed = this.dynamicTable.getDynamics(ElfDynamicType.DT_NEEDED);
        this.dynamicLibraryNames = new String[needed.length];
        for (int i = 0; i < needed.length; ++i) {
            if (this.dynamicStringTable != null) {
                try {
                    this.dynamicLibraryNames[i] = this.dynamicStringTable.readString(this.reader, needed[i].getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.dynamicLibraryNames[i] != null) continue;
            this.dynamicLibraryNames[i] = "UNK_LIB_NAME_" + i;
        }
    }

    private void parseDynamicTable() throws IOException {
        ElfProgramHeader loadHeader;
        ElfSectionHeader[] dynamicSections;
        ElfProgramHeader[] dynamicHeaders = this.getProgramHeaders(2);
        if (dynamicHeaders.length == 1) {
            long vaddr = dynamicHeaders[0].getVirtualAddress();
            if (vaddr == 0L) {
                Msg.warn((Object)this, (Object)"ELF Dynamic table appears to have been stripped from binary");
                return;
            }
            ElfProgramHeader loadHeader2 = this.getProgramLoadHeaderContaining(vaddr);
            if (loadHeader2 != null) {
                long dynamicTableOffset = loadHeader2.getOffset() + (dynamicHeaders[0].getVirtualAddress() - loadHeader2.getVirtualAddress());
                this.dynamicTable = ElfDynamicTable.createDynamicTable(this.reader, this, dynamicTableOffset, dynamicHeaders[0].getVirtualAddress());
                return;
            }
        } else if (dynamicHeaders.length > 1) {
            Msg.error((Object)this, (Object)"Multiple ELF Dynamic table program headers found");
        }
        if ((dynamicSections = this.getSections(6)).length == 1 && (loadHeader = this.getProgramLoadHeaderContaining(dynamicSections[0].getAddress())) != null) {
            long dynamicTableOffset = loadHeader.getOffset() + (dynamicSections[0].getAddress() - loadHeader.getVirtualAddress());
            this.dynamicTable = ElfDynamicTable.createDynamicTable(this.reader, this, dynamicTableOffset, dynamicSections[0].getAddress());
            return;
        }
    }

    private void parseStringTables() throws IOException {
        long dynamicStringTableAddr = -1L;
        if (this.dynamicTable != null) {
            try {
                dynamicStringTableAddr = this.adjustAddressForPrelink(this.dynamicTable.getDynamicValue(ElfDynamicType.DT_STRTAB));
            }
            catch (NotFoundException e) {
                Msg.warn((Object)this, (Object)"ELF does not contain a dynamic string table (DT_STRTAB)");
            }
        }
        ArrayList<ElfStringTable> stringTableList = new ArrayList<ElfStringTable>();
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (this.sectionHeaders[i].getType() != 3) continue;
            ElfSectionHeader stringTableSectionHeader = this.sectionHeaders[i];
            ElfStringTable stringTable = ElfStringTable.createElfStringTable(this.reader, this, stringTableSectionHeader, stringTableSectionHeader.getOffset(), this.sectionHeaders[i].getAddress(), stringTableSectionHeader.getSize());
            stringTableList.add(stringTable);
            if (stringTable.getAddressOffset() != dynamicStringTableAddr) continue;
            this.dynamicStringTable = stringTable;
        }
        if (this.dynamicStringTable == null && dynamicStringTableAddr != -1L) {
            this.dynamicStringTable = this.parseDynamicStringTable(dynamicStringTableAddr);
            if (this.dynamicStringTable != null) {
                stringTableList.add(this.dynamicStringTable);
            }
        }
        this.stringTables = new ElfStringTable[stringTableList.size()];
        stringTableList.toArray(this.stringTables);
    }

    private ElfStringTable parseDynamicStringTable(long dynamicStringTableAddr) throws IOException {
        if (!this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_STRSZ)) {
            Msg.warn((Object)this, (Object)"Failed to parse DT_STRTAB, missing dynamic dependency");
            return null;
        }
        try {
            long stringTableSize = this.dynamicTable.getDynamicValue(ElfDynamicType.DT_STRSZ);
            if (dynamicStringTableAddr == 0L) {
                Msg.warn((Object)this, (Object)("ELF Dynamic String Table of size " + stringTableSize + " appears to have been stripped from binary"));
                return null;
            }
            ElfProgramHeader stringTableLoadHeader = this.getProgramLoadHeaderContaining(dynamicStringTableAddr);
            if (stringTableLoadHeader == null) {
                Msg.warn((Object)this, (Object)("Failed to locate DT_STRTAB in memory at 0x" + Long.toHexString(dynamicStringTableAddr)));
                return null;
            }
            return ElfStringTable.createElfStringTable(this.reader, this, null, stringTableLoadHeader.getOffset(dynamicStringTableAddr), dynamicStringTableAddr, stringTableSize);
        }
        catch (NotFoundException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void parseSymbolTables() throws IOException {
        long dynamicSymbolTableAddr = -1L;
        if (this.dynamicTable != null) {
            try {
                dynamicSymbolTableAddr = this.adjustAddressForPrelink(this.dynamicTable.getDynamicValue(ElfDynamicType.DT_SYMTAB));
            }
            catch (NotFoundException e) {
                Msg.warn((Object)this, (Object)"ELF does not contain a dynamic symbol table (DT_SYMTAB)");
            }
        }
        ArrayList<ElfSymbolTable> symbolTableList = new ArrayList<ElfSymbolTable>();
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (this.sectionHeaders[i].getType() != 2 && this.sectionHeaders[i].getType() != 11) continue;
            ElfSectionHeader symbolTableSectionHeader = this.sectionHeaders[i];
            ElfSectionHeader stringTableSectionHeader = this.sectionHeaders[symbolTableSectionHeader.getLink()];
            ElfStringTable stringTable = this.getStringTable(stringTableSectionHeader);
            Msg.debug((Object)this, (Object)("Elf symbol table section " + symbolTableSectionHeader.getNameAsString() + " linked to string table section " + stringTableSectionHeader.getNameAsString()));
            boolean isDyanmic = ".dynsym".equals(symbolTableSectionHeader.getNameAsString());
            ElfSymbolTable symbolTable = ElfSymbolTable.createElfSymbolTable(this.reader, this, symbolTableSectionHeader, symbolTableSectionHeader.getOffset(), symbolTableSectionHeader.getAddress(), symbolTableSectionHeader.getSize(), symbolTableSectionHeader.getEntrySize(), stringTable, isDyanmic);
            symbolTableList.add(symbolTable);
            if (symbolTable.getAddressOffset() != dynamicSymbolTableAddr) continue;
            this.dynamicSymbolTable = symbolTable;
        }
        if (this.dynamicSymbolTable == null && dynamicSymbolTableAddr != -1L) {
            this.dynamicSymbolTable = this.parseDynamicSymbolTable();
            if (this.dynamicSymbolTable != null) {
                symbolTableList.add(this.dynamicSymbolTable);
            }
        }
        this.symbolTables = new ElfSymbolTable[symbolTableList.size()];
        symbolTableList.toArray(this.symbolTables);
    }

    private ElfSymbolTable parseDynamicSymbolTable() throws IOException {
        if (!this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_SYMTAB) || !this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_SYMENT) || !this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_HASH) && !this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_GNU_HASH)) {
            if (this.dynamicStringTable != null) {
                Msg.warn((Object)this, (Object)"Failed to parse DT_SYMTAB, missing dynamic dependency");
            }
            return null;
        }
        try {
            long tableAddr = this.dynamicTable.getDynamicValue(ElfDynamicType.DT_SYMTAB);
            if (tableAddr == 0L) {
                Msg.warn((Object)this, (Object)"ELF Dynamic String Table of size appears to have been stripped from binary");
            }
            if (this.dynamicStringTable == null) {
                Msg.warn((Object)this, (Object)"Failed to process DT_SYMTAB, missing dynamic string table");
                return null;
            }
            if (tableAddr == 0L) {
                return null;
            }
            tableAddr = this.adjustAddressForPrelink(tableAddr);
            long tableEntrySize = this.dynamicTable.getDynamicValue(ElfDynamicType.DT_SYMENT);
            boolean useGnuHash = this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_GNU_HASH);
            long hashTableAddr = useGnuHash ? this.dynamicTable.getDynamicValue(ElfDynamicType.DT_GNU_HASH) : this.dynamicTable.getDynamicValue(ElfDynamicType.DT_HASH);
            hashTableAddr = this.adjustAddressForPrelink(hashTableAddr);
            ElfProgramHeader symbolTableLoadHeader = this.getProgramLoadHeaderContaining(tableAddr);
            if (symbolTableLoadHeader == null) {
                Msg.warn((Object)this, (Object)("Failed to locate DT_SYMTAB in memory at 0x" + Long.toHexString(tableAddr)));
                return null;
            }
            ElfProgramHeader hashTableLoadHeader = this.getProgramLoadHeaderContaining(hashTableAddr);
            if (hashTableLoadHeader == null) {
                Msg.warn((Object)this, (Object)("Failed to locate DT_HASH or DT_GNU_HASH in memory at 0x" + Long.toHexString(hashTableAddr)));
                return null;
            }
            long symbolTableOffset = symbolTableLoadHeader.getOffset(tableAddr);
            long symbolHashTableOffset = hashTableLoadHeader.getOffset(hashTableAddr);
            int symCount = useGnuHash ? this.deriveGnuHashDynamicSymbolCount(symbolHashTableOffset) : this.reader.readInt(symbolHashTableOffset + 4L);
            return ElfSymbolTable.createElfSymbolTable(this.reader, this, null, symbolTableOffset, tableAddr, tableEntrySize * (long)symCount, tableEntrySize, this.dynamicStringTable, true);
        }
        catch (NotFoundException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private int deriveGnuHashDynamicSymbolCount(long gnuHashTableOffset) throws IOException {
        int chainValue;
        long bucketsOffset;
        int numBuckets = this.reader.readInt(gnuHashTableOffset);
        int symbolBase = this.reader.readInt(gnuHashTableOffset + 4L);
        int bloomSize = this.reader.readInt(gnuHashTableOffset + 8L);
        int bloomWordSize = this.is64Bit() ? 8 : 4;
        long bucketOffset = bucketsOffset = gnuHashTableOffset + 16L + (long)(bloomWordSize * bloomSize);
        int maxSymbolIndex = 0;
        for (int i = 0; i < numBuckets; ++i) {
            int symbolIndex = this.reader.readInt(bucketOffset);
            if (symbolIndex > maxSymbolIndex) {
                maxSymbolIndex = symbolIndex;
            }
            bucketOffset += 4L;
        }
        int chainIndex = maxSymbolIndex - symbolBase;
        ++maxSymbolIndex;
        long chainOffset = bucketOffset + (long)(4 * chainIndex);
        while (((chainValue = this.reader.readInt(chainOffset)) & 1) == 0) {
            ++maxSymbolIndex;
            chainOffset += 4L;
        }
        return maxSymbolIndex;
    }

    protected void parseSectionHeaders() throws IOException {
        int i;
        if (this.reader == null) {
            throw new IOException("ELF binary reader is null!");
        }
        if (this.parsedSectionHeaders) {
            return;
        }
        this.parsedSectionHeaders = true;
        this.sectionHeaders = new ElfSectionHeader[this.e_shnum];
        for (i = 0; i < this.e_shnum; ++i) {
            long index = this.e_shoff + (long)(i * this.e_shentsize);
            this.reader.setPointerIndex(index);
            this.sectionHeaders[i] = ElfSectionHeader.createElfSectionHeader(this.reader, this);
        }
        for (i = 0; i < this.e_shnum; ++i) {
            this.sectionHeaders[i].updateName();
        }
    }

    private void parseProgramHeaders() throws IOException {
        long fileLength = this.reader.length();
        this.programHeaders = new ElfProgramHeader[this.e_phnum];
        for (int i = 0; i < this.e_phnum; ++i) {
            long index = this.e_phoff + (long)(i * this.e_phentsize);
            this.reader.setPointerIndex(index);
            this.programHeaders[i] = ElfProgramHeader.createElfProgramHeader(this.reader, this);
        }
        ElfProgramHeader[] pheaders = this.getProgramHeaders();
        long size = 0L;
        for (int i = 0; i < pheaders.length; ++i) {
            size += pheaders[i].getFileSize();
        }
        if (size == fileLength) {
            long relOffset = 0L;
            for (int i = 0; i < pheaders.length; ++i) {
                pheaders[i].setOffset(relOffset);
                relOffset += pheaders[i].getFileSize();
            }
        }
    }

    public boolean isBigEndian() {
        return this.e_ident_data == 2;
    }

    public boolean isLittleEndian() {
        return this.e_ident_data == 1;
    }

    public boolean is32Bit() {
        return this.e_ident_class == 1;
    }

    public boolean is64Bit() {
        return this.e_ident_class == 2;
    }

    public long findImageBase() {
        int n = Math.min(this.e_phnum, 20);
        long minBase = -1L;
        for (int i = 0; i < n; ++i) {
            long index = this.e_phoff + (long)(i * this.e_phentsize);
            this.reader.setPointerIndex(index);
            try {
                int headerType = this.reader.peekNextInt();
                if (headerType != 1) continue;
                ElfProgramHeader header = ElfProgramHeader.createElfProgramHeader(this.reader, this);
                long addr = header.getVirtualAddress();
                if (this.is32Bit()) {
                    addr &= 0xFFFFFFFFL;
                }
                if (Long.compareUnsigned(addr, minBase) >= 0) continue;
                minBase = addr;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return minBase == -1L ? 0L : minBase;
    }

    public long getImageBase() {
        if (this.elfImageBase != null) {
            return this.elfImageBase;
        }
        this.elfImageBase = 0L;
        long base = this.getPreLinkImageBase();
        if (base != -1L) {
            this.elfImageBase = base;
        } else {
            int n = Math.min(this.programHeaders.length, 20);
            long minBase = -1L;
            for (int i = 0; i < n; ++i) {
                if (this.programHeaders[i].getType() != 1) continue;
                long addr = this.programHeaders[i].getVirtualAddress();
                if (this.is32Bit()) {
                    addr &= 0xFFFFFFFFL;
                }
                if (Long.compareUnsigned(addr, minBase) >= 0) continue;
                minBase = addr;
            }
            this.elfImageBase = minBase == -1L ? 0L : minBase;
        }
        return this.elfImageBase;
    }

    public boolean isPreLinked() {
        if (this.getPreLinkImageBase() != -1L) {
            return true;
        }
        return this.dynamicTable != null && this.dynamicTable.containsDynamicValue(ElfDynamicType.DT_GNU_PRELINKED);
    }

    private long getPreLinkImageBase() {
        if (this.preLinkImageBase != null) {
            return this.preLinkImageBase;
        }
        this.preLinkImageBase = -1L;
        try {
            long ptr = this.reader.getPointerIndex();
            long fileLength = this.reader.getByteProvider().length();
            if (fileLength < 8L) {
                return -1L;
            }
            int readInt = this.reader.readInt(fileLength - 8L);
            String readAsciiString = this.reader.readAsciiString(fileLength - 4L, 4);
            if (this.reader.getPointerIndex() != ptr) {
                this.reader.setPointerIndex(ptr);
            }
            if (readAsciiString.equals("PRE")) {
                this.preLinkImageBase = (long)readInt & 0xFFFFFFFFL;
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Elf prelink read failure", (Throwable)e);
        }
        return this.preLinkImageBase;
    }

    public boolean isSectionLoaded(ElfSectionHeader section) {
        if (section.getType() == 0) {
            return false;
        }
        long sectionStart = section.getAddress();
        if (sectionStart == 0L) {
            return false;
        }
        long sectionEnd = section.getSize() - 1L + sectionStart;
        for (ElfProgramHeader segment : this.programHeaders) {
            if (segment.getType() != 1) continue;
            long segmentStart = segment.getVirtualAddress();
            long segmentEnd = segment.getMemorySize() - 1L + segmentStart;
            if (segmentStart > sectionStart || segmentEnd < sectionEnd) continue;
            return true;
        }
        return false;
    }

    private void determineHeaderEndianess(ByteProvider provider) throws ElfException, IOException {
        if (provider.length() < (long)INITIAL_READ_LEN) {
            throw new ElfException("Not enough bytes to be a valid ELF executable.");
        }
        this.hasLittleEndianHeaders = true;
        byte[] bytes = provider.readBytes(0L, INITIAL_READ_LEN);
        if (bytes[5] == 2) {
            this.hasLittleEndianHeaders = false;
        } else if (bytes[5] != 1) {
            throw new ElfException("Unsupported Elf Header");
        }
        if (!this.hasLittleEndianHeaders && bytes[16] != 0 && bytes[20] == 1) {
            this.hasLittleEndianHeaders = true;
        }
    }

    public short e_ehsize() {
        return this.e_ehsize;
    }

    public long e_entry() {
        if (this.e_entry == 0L) {
            return 0L;
        }
        return this.adjustAddressForPrelink(this.e_entry);
    }

    public int e_flags() {
        return this.e_flags;
    }

    public short e_machine() {
        return this.e_machine;
    }

    public short e_phentsize() {
        return this.e_phentsize;
    }

    public short e_phnum() {
        return this.e_phnum;
    }

    public long e_phoff() {
        return this.e_phoff;
    }

    public short e_shentsize() {
        return this.e_shentsize;
    }

    public short e_shnum() {
        return this.e_shnum;
    }

    public long e_shoff() {
        return this.e_shoff;
    }

    public short e_shstrndx() {
        return this.e_shstrndx;
    }

    public short e_type() {
        return this.e_type;
    }

    public boolean isRelocatable() {
        return this.e_type == 1;
    }

    public boolean isSharedObject() {
        return this.e_type == 3;
    }

    public boolean isExecutable() {
        return this.e_type == 2;
    }

    public int e_version() {
        return this.e_version;
    }

    public ElfSectionHeader[] getSections() {
        return this.sectionHeaders;
    }

    public ElfSectionHeader[] getSections(int type) {
        ArrayList<ElfSectionHeader> list = new ArrayList<ElfSectionHeader>();
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (this.sectionHeaders[i].getType() != type) continue;
            list.add(this.sectionHeaders[i]);
        }
        ElfSectionHeader[] sections = new ElfSectionHeader[list.size()];
        list.toArray(sections);
        return sections;
    }

    public ElfSectionHeader getSection(String name) {
        ArrayList<ElfSectionHeader> list = new ArrayList<ElfSectionHeader>();
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (name == null || !name.equals(this.sectionHeaders[i].getNameAsString())) continue;
            list.add(this.sectionHeaders[i]);
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new RuntimeException(">1 section with name of " + name);
        }
        return (ElfSectionHeader)list.get(0);
    }

    public ElfSectionHeader getSectionAt(long address) {
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (this.sectionHeaders[i].getAddress() != address) continue;
            return this.sectionHeaders[i];
        }
        return null;
    }

    public ElfSectionHeader getSectionLoadHeaderContaining(long address) {
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (!this.sectionHeaders[i].isAlloc()) continue;
            long start = this.sectionHeaders[i].getAddress();
            long end = start + this.sectionHeaders[i].getSize();
            if (start > address || address > end) continue;
            return this.sectionHeaders[i];
        }
        return null;
    }

    public ElfSectionHeader getSectionHeaderContainingFileRange(long fileOffset, long fileRangeLength) {
        long maxOffset = fileOffset + fileRangeLength - 1L;
        for (ElfSectionHeader section : this.sectionHeaders) {
            long size;
            if (section.getType() == 0 || (size = section.getSize()) == 0L) continue;
            long start = section.getOffset();
            long end = start + size - 1L;
            if (fileOffset < start || maxOffset > end) continue;
            return section;
        }
        return null;
    }

    public int getSectionIndex(ElfSectionHeader section) {
        for (int i = 0; i < this.sectionHeaders.length; ++i) {
            if (this.sectionHeaders[i] != section) continue;
            return i;
        }
        throw new RuntimeException("Section not located.");
    }

    public ElfProgramHeader[] getProgramHeaders() {
        return this.programHeaders;
    }

    public ElfProgramHeader[] getProgramHeaders(int type) {
        ArrayList<ElfProgramHeader> list = new ArrayList<ElfProgramHeader>();
        for (int i = 0; i < this.programHeaders.length; ++i) {
            if (this.programHeaders[i].getType() != type) continue;
            list.add(this.programHeaders[i]);
        }
        ElfProgramHeader[] arr = new ElfProgramHeader[list.size()];
        list.toArray(arr);
        return arr;
    }

    public ElfDynamicTable getDynamicTable() {
        return this.dynamicTable;
    }

    public ElfProgramHeader getProgramHeaderProgramHeader() {
        ElfProgramHeader[] pharr = this.getProgramHeaders(6);
        if (pharr.length == 0 || pharr.length > 1) {
            return null;
        }
        return pharr[0];
    }

    public ElfProgramHeader getProgramHeaderAt(long virtualAddr) {
        for (int i = 0; i < this.programHeaders.length; ++i) {
            if (this.programHeaders[i].getVirtualAddress() != virtualAddr) continue;
            return this.programHeaders[i];
        }
        return null;
    }

    public ElfProgramHeader getProgramLoadHeaderContaining(long virtualAddr) {
        for (int i = 0; i < this.programHeaders.length; ++i) {
            if (this.programHeaders[i] == null || this.programHeaders[i].getType() != 1) continue;
            long start = this.programHeaders[i].getVirtualAddress();
            long end = this.programHeaders[i].getAdjustedMemorySize() - 1L + start;
            if (virtualAddr < start || virtualAddr > end) continue;
            return this.programHeaders[i];
        }
        return null;
    }

    public ElfProgramHeader getProgramLoadHeaderContainingFileOffset(long offset) {
        for (int i = 0; i < this.programHeaders.length; ++i) {
            if (this.programHeaders[i] == null || this.programHeaders[i].getType() != 1) continue;
            long start = this.programHeaders[i].getOffset();
            long end = start + (this.programHeaders[i].getFileSize() - 1L);
            if (offset < start || offset > end) continue;
            return this.programHeaders[i];
        }
        return null;
    }

    public String[] getDynamicLibraryNames() {
        return this.dynamicLibraryNames;
    }

    public ElfStringTable getDynamicStringTable() {
        return this.dynamicStringTable;
    }

    public ElfStringTable[] getStringTables() {
        return this.stringTables;
    }

    public ElfStringTable getStringTable(ElfSectionHeader section) {
        for (int i = 0; i < this.stringTables.length; ++i) {
            if (this.stringTables[i].getFileOffset() != section.getOffset()) continue;
            return this.stringTables[i];
        }
        return null;
    }

    public ElfSymbolTable getDynamicSymbolTable() {
        return this.dynamicSymbolTable;
    }

    public ElfSymbolTable[] getSymbolTables() {
        return this.symbolTables;
    }

    public ElfSymbolTable getSymbolTable(ElfSectionHeader symbolTableSection) {
        for (int i = 0; i < this.symbolTables.length; ++i) {
            if (this.symbolTables[i].getFileOffset() != symbolTableSection.getOffset()) continue;
            return this.symbolTables[i];
        }
        return null;
    }

    public ElfRelocationTable[] getRelocationTables() {
        return this.relocationTables;
    }

    public ElfRelocationTable getRelocationTable(ElfSectionHeader relocSection) {
        for (int i = 0; i < this.relocationTables.length; ++i) {
            if (this.relocationTables[i].getFileOffset() != relocSection.getOffset()) continue;
            return this.relocationTables[i];
        }
        return null;
    }

    public String getMachineName() {
        return Short.toString(this.e_machine);
    }

    public String getFlags() {
        return Integer.toString(this.e_flags);
    }

    @Override
    public DataType toDataType() {
        if (this.headerStructure != null) {
            return this.headerStructure;
        }
        String name = this.is32Bit() ? "Elf32_Ehdr" : "Elf64_Ehdr";
        this.headerStructure = new StructureDataType(new CategoryPath("/ELF"), name, 0);
        this.headerStructure.add(BYTE, "e_ident_magic_num", null);
        this.headerStructure.add(STRING, this.e_ident_magic_str.length(), "e_ident_magic_str", null);
        this.headerStructure.add(BYTE, "e_ident_class", null);
        this.headerStructure.add(BYTE, "e_ident_data", null);
        this.headerStructure.add(BYTE, "e_ident_version", null);
        this.headerStructure.add((DataType)new ArrayDataType(BYTE, this.e_ident_pad.length, 1), "e_ident_pad", null);
        this.headerStructure.add(WORD, "e_type", null);
        this.headerStructure.add(WORD, "e_machine", null);
        this.headerStructure.add(DWORD, "e_version", null);
        if (this.is32Bit()) {
            this.headerStructure.add(DWORD, "e_entry", null);
            this.headerStructure.add(DWORD, "e_phoff", null);
            this.headerStructure.add(DWORD, "e_shoff", null);
        } else {
            this.headerStructure.add(QWORD, "e_entry", null);
            this.headerStructure.add(QWORD, "e_phoff", null);
            this.headerStructure.add(QWORD, "e_shoff", null);
        }
        this.headerStructure.add(DWORD, "e_flags", null);
        this.headerStructure.add(WORD, "e_ehsize", null);
        this.headerStructure.add(WORD, "e_phentsize", null);
        this.headerStructure.add(WORD, "e_phnum", null);
        this.headerStructure.add(WORD, "e_shentsize", null);
        this.headerStructure.add(WORD, "e_shnum", null);
        this.headerStructure.add(WORD, "e_shstrndx", null);
        return this.headerStructure;
    }

    public int getEntryComponentOrdinal() {
        return 9;
    }

    public int getPhoffComponentOrdinal() {
        return 10;
    }

    public int getShoffComponentOrdinal() {
        return 11;
    }

    private void addSection(ElfSectionHeader newSection) {
        this.e_shnum = (short)(this.e_shnum + 1);
        ElfSectionHeader[] tmp = new ElfSectionHeader[this.e_shnum];
        System.arraycopy(this.sectionHeaders, 0, tmp, 0, this.sectionHeaders.length);
        this.sectionHeaders = tmp;
        this.sectionHeaders[this.e_shnum - 1] = newSection;
        if (this.e_shnum != this.sectionHeaders.length) {
            throw new IllegalStateException();
        }
    }

    public ElfSectionHeader addSection(MemoryBlock block, int sh_name) throws MemoryAccessException {
        ElfSectionHeader newSection = new ElfSectionHeader(this, block, sh_name, this.getImageBase());
        this.addSection(newSection);
        return newSection;
    }

    public ElfSectionHeader addSection(String name, int sh_name) {
        return this.addSection(name, sh_name, 1);
    }

    public ElfSectionHeader addSection(String name, int sh_name, int type) {
        ElfSectionHeader newSection = new ElfSectionHeader(this, name, sh_name, type);
        this.addSection(newSection);
        return newSection;
    }

    public void addProgramHeader(ElfProgramHeader ph) {
        Object[] tmp = new ElfProgramHeader[this.e_phnum + 1];
        int pos = tmp.length - 1;
        boolean firstLoad = true;
        int firstLoadPos = -1;
        if (ph.getType() == 1) {
            for (int i = 0; i < this.programHeaders.length - 1; ++i) {
                if (this.programHeaders[i].getType() != 1) continue;
                if (firstLoad) {
                    firstLoad = false;
                    firstLoadPos = i;
                }
                pos = i;
            }
            ++pos;
        }
        System.arraycopy(this.programHeaders, 0, tmp, 0, pos);
        tmp[pos] = ph;
        System.arraycopy(this.programHeaders, pos, tmp, pos + 1, this.programHeaders.length - pos);
        if (ph.getType() == 1) {
            Arrays.sort(tmp, firstLoadPos, pos + 1);
        }
        this.programHeaders = tmp;
        this.e_phnum = (short)(this.e_phnum + 1);
        if (this.e_phnum != this.programHeaders.length) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.seek(0L);
        raf.writeByte(this.e_ident_magic_num);
        raf.write(this.e_ident_magic_str.getBytes());
        raf.writeByte(this.e_ident_class);
        raf.writeByte(this.e_ident_data);
        raf.writeByte(this.e_ident_version);
        raf.write(this.e_ident_pad);
        raf.write(dc.getBytes(this.e_type));
        raf.write(dc.getBytes(this.e_machine));
        raf.write(dc.getBytes(this.e_version));
        if (this.is32Bit()) {
            raf.write(dc.getBytes((int)this.e_entry));
            raf.write(dc.getBytes((int)this.e_phoff));
            raf.write(dc.getBytes((int)this.e_shoff));
        } else if (this.is64Bit()) {
            raf.write(dc.getBytes(this.e_entry));
            raf.write(dc.getBytes(this.e_phoff));
            raf.write(dc.getBytes(this.e_shoff));
        }
        raf.write(dc.getBytes(this.e_flags));
        raf.write(dc.getBytes(this.e_ehsize));
        raf.write(dc.getBytes(this.e_phentsize));
        raf.write(dc.getBytes(this.e_phnum));
        raf.write(dc.getBytes(this.e_shentsize));
        raf.write(dc.getBytes(this.e_shnum));
        raf.write(dc.getBytes(this.e_shstrndx));
    }

    public void setSectionHeaderOffset(long offset) {
        this.e_shoff = offset;
    }

    public void setProgramHeaderOffset(long offset) {
        this.e_phoff = offset;
    }
}

