/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.mz;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.Writeable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DOSHeader
implements StructConverter,
Writeable {
    public static final String NAME = "IMAGE_DOS_HEADER";
    public static final int IMAGE_DOS_SIGNATURE = 23117;
    public static final int SIZEOF_DOS_HEADER = 64;
    private short e_magic;
    private short e_cblp;
    private short e_cp;
    private short e_crlc;
    private short e_cparhdr;
    private short e_minalloc;
    private short e_maxalloc;
    private short e_ss;
    private short e_sp;
    private short e_csum;
    private short e_ip;
    private short e_cs;
    private short e_lfarlc;
    private short e_ovno;
    private short[] e_res = new short[4];
    private short e_oemid;
    private short e_oeminfo;
    private short[] e_res2 = new short[10];
    private int e_lfanew;
    private byte[] stubBytes;
    private FactoryBundledWithBinaryReader reader;

    public static DOSHeader createDOSHeader(FactoryBundledWithBinaryReader reader) throws IOException {
        DOSHeader dosHeader = (DOSHeader)reader.getFactory().create(DOSHeader.class, new Object[0]);
        dosHeader.initDOSHeader(reader);
        return dosHeader;
    }

    private void initDOSHeader(FactoryBundledWithBinaryReader reader) throws IOException {
        this.reader = reader;
        this.parse();
    }

    public String getProcessorName() {
        return "x86";
    }

    public short e_magic() {
        return this.e_magic;
    }

    public short e_cblp() {
        return this.e_cblp;
    }

    public short e_cp() {
        return this.e_cp;
    }

    public short e_crlc() {
        return this.e_crlc;
    }

    public short e_cparhdr() {
        return this.e_cparhdr;
    }

    public short e_minalloc() {
        return this.e_minalloc;
    }

    public short e_maxalloc() {
        return this.e_maxalloc;
    }

    public short e_ss() {
        return this.e_ss;
    }

    public short e_sp() {
        return this.e_sp;
    }

    public short e_csum() {
        return this.e_csum;
    }

    public short e_ip() {
        return this.e_ip;
    }

    public short e_cs() {
        return this.e_cs;
    }

    public short e_lfarlc() {
        return this.e_lfarlc;
    }

    public short e_ovno() {
        return this.e_ovno;
    }

    public short[] e_res() {
        return this.e_res;
    }

    public short e_oemid() {
        return this.e_oemid;
    }

    public short e_oeminfo() {
        return this.e_oeminfo;
    }

    public short[] e_res2() {
        return this.e_res2;
    }

    public int e_lfanew() {
        return this.e_lfanew;
    }

    public boolean hasNewExeHeader() {
        return this.e_lfanew >= 0 && this.e_lfanew <= 65536 && this.e_lfarlc == 64;
    }

    public boolean isDosSignature() {
        return this.e_magic == 23117;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add((DataType)new ArrayDataType(ASCII, 2, 1));
        for (int i = 1; i <= 13; ++i) {
            struct.add(WORD);
        }
        struct.add((DataType)new ArrayDataType(WORD, 4, 2));
        struct.add(WORD);
        struct.add(WORD);
        struct.add((DataType)new ArrayDataType(WORD, 10, 2));
        struct.add(DWORD);
        if (this.getProgramLen() > 0) {
            struct.add((DataType)new ArrayDataType(BYTE, this.getProgramLen(), 1));
        }
        struct.getComponent(0).setFieldName("e_magic");
        struct.getComponent(1).setFieldName("e_cblp");
        struct.getComponent(2).setFieldName("e_cp");
        struct.getComponent(3).setFieldName("e_crlc");
        struct.getComponent(4).setFieldName("e_cparhdr");
        struct.getComponent(5).setFieldName("e_minalloc");
        struct.getComponent(6).setFieldName("e_maxalloc");
        struct.getComponent(7).setFieldName("e_ss");
        struct.getComponent(8).setFieldName("e_sp");
        struct.getComponent(9).setFieldName("e_csum");
        struct.getComponent(10).setFieldName("e_ip");
        struct.getComponent(11).setFieldName("e_cs");
        struct.getComponent(12).setFieldName("e_lfarlc");
        struct.getComponent(13).setFieldName("e_ovno");
        struct.getComponent(14).setFieldName("e_res[4]");
        struct.getComponent(15).setFieldName("e_oemid");
        struct.getComponent(16).setFieldName("e_oeminfo");
        struct.getComponent(17).setFieldName("e_res2[10]");
        struct.getComponent(18).setFieldName("e_lfanew");
        if (this.getProgramLen() > 0) {
            struct.getComponent(19).setFieldName("e_program");
        }
        struct.getComponent(0).setComment("Magic number");
        struct.getComponent(1).setComment("Bytes of last page");
        struct.getComponent(2).setComment("Pages in file");
        struct.getComponent(3).setComment("Relocations");
        struct.getComponent(4).setComment("Size of header in paragraphs");
        struct.getComponent(5).setComment("Minimum extra paragraphs needed");
        struct.getComponent(6).setComment("Maximum extra paragraphs needed");
        struct.getComponent(7).setComment("Initial (relative) SS value");
        struct.getComponent(8).setComment("Initial SP value");
        struct.getComponent(9).setComment("Checksum");
        struct.getComponent(10).setComment("Initial IP value");
        struct.getComponent(11).setComment("Initial (relative) CS value");
        struct.getComponent(12).setComment("File address of relocation table");
        struct.getComponent(13).setComment("Overlay number");
        struct.getComponent(14).setComment("Reserved words");
        struct.getComponent(15).setComment("OEM identifier (for e_oeminfo)");
        struct.getComponent(16).setComment("OEM information; e_oemid specific");
        struct.getComponent(17).setComment("Reserved words");
        struct.getComponent(18).setComment("File address of new exe header");
        if (this.getProgramLen() > 0) {
            struct.getComponent(19).setComment("Actual DOS program");
        }
        struct.setCategoryPath(new CategoryPath("/DOS"));
        return struct;
    }

    public int getProgramLen() {
        return this.stubBytes == null ? 0 : this.stubBytes.length;
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(0);
        this.e_magic = this.reader.readNextShort();
        if (this.e_magic != 23117) {
            return;
        }
        this.e_cblp = this.reader.readNextShort();
        this.e_cp = this.reader.readNextShort();
        this.e_crlc = this.reader.readNextShort();
        this.e_cparhdr = this.reader.readNextShort();
        this.e_minalloc = this.reader.readNextShort();
        this.e_maxalloc = this.reader.readNextShort();
        this.e_ss = this.reader.readNextShort();
        this.e_sp = this.reader.readNextShort();
        this.e_csum = this.reader.readNextShort();
        this.e_ip = this.reader.readNextShort();
        this.e_cs = this.reader.readNextShort();
        this.e_lfarlc = this.reader.readNextShort();
        this.e_ovno = this.reader.readNextShort();
        this.e_res = this.reader.readNextShortArray(4);
        this.e_oemid = this.reader.readNextShort();
        this.e_oeminfo = this.reader.readNextShort();
        this.e_res2 = this.reader.readNextShortArray(10);
        this.e_lfanew = this.reader.readNextInt();
        if (this.isDosSignature() && this.e_lfanew < 65536) {
            try {
                this.stubBytes = this.e_lfanew > 64 ? this.reader.readByteArray(64L, this.e_lfanew - 64) : new byte[]{};
            }
            catch (Exception exc) {
                this.stubBytes = new byte[0];
            }
        } else {
            this.stubBytes = new byte[0];
        }
    }

    public void decrementStub(int start) {
        if (this.stubBytes.length > 0) {
            try {
                this.stubBytes = start > 64 ? this.reader.readByteArray(64L, start - 64) : new byte[]{};
            }
            catch (Exception exc) {
                this.stubBytes = new byte[0];
            }
        }
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.write(dc.getBytes(this.e_magic));
        raf.write(dc.getBytes(this.e_cblp));
        raf.write(dc.getBytes(this.e_cp));
        raf.write(dc.getBytes(this.e_crlc));
        raf.write(dc.getBytes(this.e_cparhdr));
        raf.write(dc.getBytes(this.e_minalloc));
        raf.write(dc.getBytes(this.e_maxalloc));
        raf.write(dc.getBytes(this.e_ss));
        raf.write(dc.getBytes(this.e_sp));
        raf.write(dc.getBytes(this.e_csum));
        raf.write(dc.getBytes(this.e_ip));
        raf.write(dc.getBytes(this.e_cs));
        raf.write(dc.getBytes(this.e_lfarlc));
        raf.write(dc.getBytes(this.e_ovno));
        for (short e_re : this.e_res) {
            raf.write(dc.getBytes(e_re));
        }
        raf.write(dc.getBytes(this.e_oemid));
        raf.write(dc.getBytes(this.e_oeminfo));
        for (short element : this.e_res2) {
            raf.write(dc.getBytes(element));
        }
        raf.write(dc.getBytes(this.e_lfanew));
        raf.write(this.stubBytes);
    }
}

