/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigField;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigLocalVar;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigStandAloneMethod;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableStandAloneSig
extends CliAbstractTable {
    public CliTableStandAloneSig(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliStandAloneSigRow(this.readBlobIndex(reader)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "StandAloneSig Row", 0);
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", null);
        return rowDt;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            Integer sigIndex = ((CliStandAloneSigRow)row).signatureIndex;
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(((CliStandAloneSigRow)row).signatureIndex);
            Address addr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), sigIndex);
            if (CliSigLocalVar.isLocalVarSig(blob)) {
                CliSigLocalVar localSig = new CliSigLocalVar(blob);
                this.metadataStream.getBlobStream().updateBlob(localSig, addr, program);
                continue;
            }
            if (CliSigField.isFieldSig(blob)) {
                CliSigField fieldSig = new CliSigField(blob);
                this.metadataStream.getBlobStream().updateBlob(fieldSig, addr, program);
                continue;
            }
            CliSigStandAloneMethod standAloneSig = new CliSigStandAloneMethod(blob);
            this.metadataStream.getBlobStream().updateBlob(standAloneSig, addr, program);
        }
    }

    public class CliStandAloneSigRow
    extends CliAbstractTableRow {
        public int signatureIndex;

        public CliStandAloneSigRow(int signatureIndex) {
            this.signatureIndex = signatureIndex;
        }

        @Override
        public String getRepresentation() {
            String sigRep = Integer.toHexString(this.signatureIndex);
            CliBlob sigBlob = CliTableStandAloneSig.this.metadataStream.getBlobStream().getBlob(this.signatureIndex);
            try {
                CliAbstractSig sig = CliSigLocalVar.isLocalVarSig(sigBlob) ? new CliSigLocalVar(sigBlob) : (CliSigField.isFieldSig(sigBlob) ? new CliSigField(sigBlob) : new CliSigStandAloneMethod(sigBlob));
                sigRep = sig.getRepresentation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("%s", sigRep);
        }
    }
}

