/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunctionIndirect;
import ghidra.app.util.demangler.DemangledFunctionReference;
import ghidra.app.util.demangler.DemangledObjectFactory;
import ghidra.app.util.demangler.ParameterReceiver;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import java.util.ArrayList;
import java.util.List;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledFunctionPointer;
import util.demangler.GenericDemangledType;

public class DemangledFunctionPointer
extends DemangledDataType
implements ParameterReceiver {
    private static final String DEFAULT_NAME_PREFIX = "FuncDef";
    private static final Object NAMESPACE_DELIMITER = "::";
    private static final String EMPTY_STRING = "";
    private static int ID = 0;
    private DemangledDataType returnType;
    protected String callingConvention;
    private List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();
    protected String modifier;
    protected boolean isConstPointer;
    private String parentName;
    private boolean isTrailingPointer64;
    private boolean isTrailingUnaligned;
    private boolean isTrailingRestrict;
    private boolean displayFunctionPointerParens = true;

    public DemangledFunctionPointer() {
        super(DEFAULT_NAME_PREFIX + DemangledFunctionPointer.nextID());
    }

    private static synchronized int nextID() {
        return ID++;
    }

    DemangledFunctionPointer(GenericDemangledFunctionPointer generic) {
        super((GenericDemangledDataType)generic);
        ID = generic.getID();
        this.returnType = (DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)generic.getReturnType());
        this.callingConvention = generic.getCallingConvention();
        this.isConstPointer = generic.isConstPointer();
        this.parentName = generic.getParentName();
        this.isTrailingPointer64 = generic.isTrailingPointer64();
        List genericParameters = generic.getParameters();
        for (GenericDemangledDataType parameter : genericParameters) {
            this.parameters.add((DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)parameter));
        }
    }

    public DemangledDataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(DemangledDataType returnType) {
        this.returnType = returnType;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public boolean isConstPointer() {
        return this.isConstPointer;
    }

    public void setConstPointer() {
        this.isConstPointer = true;
    }

    public boolean isTrailingPointer64() {
        return this.isTrailingPointer64;
    }

    public void setTrailingPointer64() {
        this.isTrailingPointer64 = true;
    }

    public boolean isTrailingUnaligned() {
        return this.isTrailingUnaligned;
    }

    public void setTrailingUnaligned() {
        this.isTrailingUnaligned = true;
    }

    public boolean isTrailingRestrict() {
        return this.isTrailingRestrict;
    }

    public void setTrailingRestrict() {
        this.isTrailingRestrict = true;
    }

    public void setDisplayFunctionPointerParens(boolean b) {
        this.displayFunctionPointerParens = b;
    }

    @Override
    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    @Override
    public DemangledDataType copy() {
        DemangledFunctionPointer copy = new DemangledFunctionPointer();
        this.copy(this, copy);
        return copy;
    }

    @Override
    protected void copy(DemangledDataType source, DemangledDataType destination) {
        super.copy(source, destination);
        if (source instanceof DemangledFunctionPointer && destination instanceof DemangledFunctionPointer) {
            DemangledFunctionPointer copySource = (DemangledFunctionPointer)source;
            DemangledFunctionPointer copyDestination = (DemangledFunctionPointer)destination;
            copyDestination.returnType = copySource.returnType.copy();
            for (DemangledDataType parameter : copySource.parameters) {
                copyDestination.parameters.add(parameter.copy());
            }
            copyDestination.callingConvention = copySource.callingConvention;
        }
    }

    @Override
    public String toSignature() {
        return this.toSignature(null);
    }

    public String toSignature(String name) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer buffer1 = new StringBuffer();
        String s = this.getConventionPointerNameString(name);
        if (s.contains(" ") || s.isEmpty()) {
            this.addFunctionPointerParens(buffer1, s);
        } else {
            buffer1.append(s);
        }
        buffer1.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            buffer1.append(this.parameters.get(i).toSignature());
            if (i >= this.parameters.size() - 1) continue;
            buffer1.append(',');
        }
        buffer1.append(')');
        if (this.returnType instanceof DemangledFunctionPointer) {
            buffer.append(((DemangledFunctionPointer)this.returnType).toSignature(buffer1.toString())).append(' ');
        } else if (this.returnType instanceof DemangledFunctionReference) {
            buffer.append(((DemangledFunctionReference)this.returnType).toSignature(buffer1.toString())).append(' ');
        } else if (this.returnType instanceof DemangledFunctionIndirect) {
            buffer.append(((DemangledFunctionIndirect)this.returnType).toSignature(buffer1.toString())).append(' ');
        } else {
            buffer.append(this.returnType.toSignature()).append(' ');
            buffer.append(buffer1);
        }
        if (this.isConst()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("const");
        }
        if (this.isVolatile()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("volatile");
        }
        if (this.isTrailingUnaligned) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__unaligned");
        }
        if (this.isTrailingPointer64) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        if (this.isTrailingRestrict) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__restrict");
        }
        return buffer.toString();
    }

    private void addFunctionPointerParens(StringBuffer buffer, String s) {
        if (!this.displayFunctionPointerParens) {
            return;
        }
        buffer.append('(').append(s).append(')');
    }

    private String getConventionPointerNameString(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.callingConvention == null ? EMPTY_STRING : this.callingConvention);
        int pointerLevels = this.getPointerLevels();
        if (pointerLevels > 0) {
            if (this.callingConvention != null) {
                buffer.append(' ');
            }
            this.addParentName(buffer);
            for (int i = 0; i < pointerLevels; ++i) {
                buffer.append('*');
            }
        }
        if (this.modifier != null && this.modifier.length() != 0) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append(this.modifier);
        }
        if (this.isConstPointer) {
            buffer.append("const");
        }
        if (this.isPointer64()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        if (name != null) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append(name);
        }
        return buffer.toString();
    }

    private void addParentName(StringBuilder buffer) {
        char lastChar;
        if (this.parentName == null) {
            return;
        }
        if (this.parentName.startsWith(DEFAULT_NAME_PREFIX)) {
            return;
        }
        if (buffer.length() > 2 && ' ' != (lastChar = buffer.charAt(buffer.length() - 1))) {
            buffer.append(' ');
        }
        buffer.append(this.parentName).append(NAMESPACE_DELIMITER);
    }

    @Override
    public DataType getDataType(DataTypeManager dataTypeManager) {
        DataType dt;
        FunctionDefinitionDataType fddt = new FunctionDefinitionDataType(this.getName());
        fddt.setReturnType(this.returnType.getDataType(dataTypeManager));
        if (this.parameters.size() != 1 || !(this.parameters.get(0).getDataType(dataTypeManager) instanceof VoidDataType)) {
            ParameterDefinition[] params = new ParameterDefinition[this.parameters.size()];
            for (int i = 0; i < this.parameters.size(); ++i) {
                params[i] = new ParameterDefinitionImpl(null, this.parameters.get(i).getDataType(dataTypeManager), null);
            }
            fddt.setArguments(params);
        }
        if ((dt = DemangledDataType.findDataType(dataTypeManager, this.namespace, this.getName())) == null || !(dt instanceof FunctionDefinitionDataType)) {
            dt = fddt;
        }
        return new PointerDataType(dt, dataTypeManager);
    }
}

