/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.exporter.Exporter;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.List;

public class ProjectArchiveExporter
extends Exporter {
    public static final String NAME = "Ghidra Data Type File";

    public ProjectArchiveExporter() {
        super(NAME, "gdt", null);
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) {
        try {
            file.delete();
            domainObj.saveToPackedFile(file, monitor);
        }
        catch (UnsupportedOperationException e) {
            this.log.appendMsg("Content does not support packed file export!");
            this.log.appendException((Throwable)e);
            return false;
        }
        catch (CancelledException ce) {
            return false;
        }
        catch (Exception e) {
            this.log.appendMsg("Unexpected exception exporting file: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        return EMPTY_OPTIONS;
    }

    @Override
    public void setOptions(List<Option> options) {
    }

    @Override
    public boolean canExportDomainObject(Class<? extends DomainObject> domainObjectClass) {
        return DataTypeArchive.class.isAssignableFrom(domainObjectClass);
    }
}

